/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:     doublee.c
 * Abstract:        double-extension word set
 */

#include "yforth.h"
#include "doublee.h"

/**************************************************************************/
/* WORDS ******************************************************************/
/**************************************************************************/

void _two_rote() {
	register DCell d1 = GET_DCELL(sp);
	register DCell d2 = GET_DCELL(sp + 2);
	register DCell d3 = GET_DCELL(sp + 4);
	PUT_DCELL(sp, d3);
	PUT_DCELL(sp + 2, d1);
	PUT_DCELL(sp + 4, d2);
}

void _d_u_less() {
	register UDCell ud1 = GET_DCELL(sp + 2);
	register UDCell ud2 = GET_DCELL(sp);
	sp += 3;
	sp[0] = FFLAG(ud1 < ud2);
}

