/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import org.jmol.util.Logger;

class Huffman {
    private int bufferPutBits;
    private int bufferPutBuffer;
    int ImageHeight;
    int ImageWidth;
    private int[][] DC_matrix0;
    private int[][] AC_matrix0;
    private int[][] DC_matrix1;
    private int[][] AC_matrix1;
    private int[][][] DC_matrix;
    private int[][][] AC_matrix;
    int NumOfDCTables;
    int NumOfACTables;
    static final int[] bitsDCluminance = new int[]{0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    static final int[] valDCluminance = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    static final int[] bitsDCchrominance = new int[]{1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    static final int[] valDCchrominance = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    static final int[] bitsACluminance = new int[]{16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    static final int[] valACluminance = new int[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, 129, 145, 161, 8, 35, 66, 177, 193, 21, 82, 209, 240, 36, 51, 98, 114, 130, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    static final int[] bitsACchrominance = new int[]{17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    static final int[] valACchrominance = new int[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, 129, 8, 20, 66, 145, 161, 177, 193, 9, 35, 51, 82, 240, 21, 98, 114, 209, 10, 22, 36, 52, 225, 37, 241, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    static final int[] jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    Huffman(int n, int n2) {
        this.initHuf();
        this.ImageWidth = n;
        this.ImageHeight = n2;
    }

    void HuffmanBlockEncoder(BufferedOutputStream bufferedOutputStream, int[] nArray, int n, int n2, int n3) {
        this.NumOfDCTables = 2;
        this.NumOfACTables = 2;
        int[][] nArray2 = this.DC_matrix[n2];
        int[][] nArray3 = this.AC_matrix[n3];
        int n4 = nArray[0] - n;
        int n5 = n4;
        if (n5 < 0) {
            n5 = -n5;
            --n4;
        }
        int n6 = 0;
        while (n5 != 0) {
            ++n6;
            n5 >>= 1;
        }
        this.bufferIt(bufferedOutputStream, nArray2[n6][0], nArray2[n6][1]);
        if (n6 != 0) {
            this.bufferIt(bufferedOutputStream, n4, n6);
        }
        int n7 = 0;
        for (int i = 1; i < 64; ++i) {
            n5 = nArray[jpegNaturalOrder[i]];
            if (n5 == 0) {
                ++n7;
                continue;
            }
            while (n7 > 15) {
                this.bufferIt(bufferedOutputStream, nArray3[240][0], nArray3[240][1]);
                n7 -= 16;
            }
            n4 = n5;
            if (n5 < 0) {
                n5 = -n5;
                --n4;
            }
            n6 = 1;
            while ((n5 >>= 1) != 0) {
                ++n6;
            }
            int n8 = (n7 << 4) + n6;
            this.bufferIt(bufferedOutputStream, nArray3[n8][0], nArray3[n8][1]);
            this.bufferIt(bufferedOutputStream, n4, n6);
            n7 = 0;
        }
        if (n7 > 0) {
            this.bufferIt(bufferedOutputStream, nArray3[0][0], nArray3[0][1]);
        }
    }

    void bufferIt(BufferedOutputStream bufferedOutputStream, int n, int n2) {
        int n3 = n;
        int n4 = this.bufferPutBits;
        n3 &= (1 << n2) - 1;
        n3 <<= 24 - (n4 += n2);
        n3 |= this.bufferPutBuffer;
        while (n4 >= 8) {
            int n5 = n3 >> 16 & 0xFF;
            try {
                bufferedOutputStream.write(n5);
            }
            catch (IOException iOException) {
                Logger.error("IO Error", iOException);
            }
            if (n5 == 255) {
                try {
                    bufferedOutputStream.write(0);
                }
                catch (IOException iOException) {
                    Logger.error("IO Error", iOException);
                }
            }
            n3 <<= 8;
            n4 -= 8;
        }
        this.bufferPutBuffer = n3;
        this.bufferPutBits = n4;
    }

    void flushBuffer(BufferedOutputStream bufferedOutputStream) {
        int n;
        int n2;
        int n3 = this.bufferPutBuffer;
        for (n2 = this.bufferPutBits; n2 >= 8; n2 -= 8) {
            n = n3 >> 16 & 0xFF;
            try {
                bufferedOutputStream.write(n);
            }
            catch (IOException iOException) {
                Logger.error("IO Error", iOException);
            }
            if (n == 255) {
                try {
                    bufferedOutputStream.write(0);
                }
                catch (IOException iOException) {
                    Logger.error("IO Error", iOException);
                }
            }
            n3 <<= 8;
        }
        if (n2 > 0) {
            n = n3 >> 16 & 0xFF;
            try {
                bufferedOutputStream.write(n);
            }
            catch (IOException iOException) {
                Logger.error("IO Error", iOException);
            }
        }
    }

    private void initHuf() {
        int n;
        int n2;
        this.DC_matrix0 = new int[12][2];
        this.DC_matrix1 = new int[12][2];
        this.AC_matrix0 = new int[255][2];
        this.AC_matrix1 = new int[255][2];
        this.DC_matrix = new int[2][][];
        this.AC_matrix = new int[2][][];
        int[] nArray = new int[257];
        int[] nArray2 = new int[257];
        int n3 = 0;
        for (n2 = 1; n2 <= 16; ++n2) {
            n = bitsDCchrominance[n2];
            while (--n >= 0) {
                nArray[n3++] = n2;
            }
        }
        nArray[n3] = 0;
        int n4 = n3;
        int n5 = 0;
        int n6 = nArray[0];
        n3 = 0;
        while (nArray[n3] != 0) {
            while (nArray[n3] == n6) {
                nArray2[n3++] = n5++;
            }
            n5 <<= 1;
            ++n6;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.DC_matrix1[Huffman.valDCchrominance[n3]][0] = nArray2[n3];
            this.DC_matrix1[Huffman.valDCchrominance[n3]][1] = nArray[n3];
        }
        n3 = 0;
        for (n2 = 1; n2 <= 16; ++n2) {
            n = bitsACchrominance[n2];
            while (--n >= 0) {
                nArray[n3++] = n2;
            }
        }
        nArray[n3] = 0;
        n4 = n3;
        n5 = 0;
        n6 = nArray[0];
        n3 = 0;
        while (nArray[n3] != 0) {
            while (nArray[n3] == n6) {
                nArray2[n3++] = n5++;
            }
            n5 <<= 1;
            ++n6;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.AC_matrix1[Huffman.valACchrominance[n3]][0] = nArray2[n3];
            this.AC_matrix1[Huffman.valACchrominance[n3]][1] = nArray[n3];
        }
        n3 = 0;
        for (n2 = 1; n2 <= 16; ++n2) {
            n = bitsDCluminance[n2];
            while (--n >= 0) {
                nArray[n3++] = n2;
            }
        }
        nArray[n3] = 0;
        n4 = n3;
        n5 = 0;
        n6 = nArray[0];
        n3 = 0;
        while (nArray[n3] != 0) {
            while (nArray[n3] == n6) {
                nArray2[n3++] = n5++;
            }
            n5 <<= 1;
            ++n6;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.DC_matrix0[Huffman.valDCluminance[n3]][0] = nArray2[n3];
            this.DC_matrix0[Huffman.valDCluminance[n3]][1] = nArray[n3];
        }
        n3 = 0;
        for (n2 = 1; n2 <= 16; ++n2) {
            n = bitsACluminance[n2];
            while (--n >= 0) {
                nArray[n3++] = n2;
            }
        }
        nArray[n3] = 0;
        n4 = n3;
        n5 = 0;
        n6 = nArray[0];
        n3 = 0;
        while (nArray[n3] != 0) {
            while (nArray[n3] == n6) {
                nArray2[n3++] = n5++;
            }
            n5 <<= 1;
            ++n6;
        }
        for (int i = 0; i < n4; ++i) {
            this.AC_matrix0[Huffman.valACluminance[i]][0] = nArray2[i];
            this.AC_matrix0[Huffman.valACluminance[i]][1] = nArray[i];
        }
        this.DC_matrix[0] = this.DC_matrix0;
        this.DC_matrix[1] = this.DC_matrix1;
        this.AC_matrix[0] = this.AC_matrix0;
        this.AC_matrix[1] = this.AC_matrix1;
    }
}

