unit dlclock;

{$mode objfpc}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,dateutils
  , StdCtrls, ExtCtrls, Grids
  , StrUtils  //AnsiMidStr
  , lazutf8sysutils // NOWUTC
  , LazSysUtils //For NowUTC
  ;

type

  { TForm6 }

  TForm6 = class(TForm)
    CloseButton: TButton;
    Label1: TLabel;
    UnitClockText: TLabeledEdit;
    UTCClockText: TLabeledEdit;
    LocalTimeText: TLabeledEdit;
    DifferenceTimeText: TLabeledEdit;
    PauseClockButton: TButton;
    ResumClockButton: TButton;
    SetDeviceClock: TButton;
    Timer1: TTimer;
    procedure CloseButtonClick(Sender: TObject);
    procedure PauseClockButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ResumClockButtonClick(Sender: TObject);
    procedure SetDeviceClockClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { private declarations }
    procedure ExecuteQueue();
  public
    { public declarations }
  end;

var
  Form6: TForm6;

implementation
uses
  Unit1,
  header_utils;
{ TForm6 }

procedure TForm6.Timer1Timer(Sender: TObject);
{ This timer runs once per second.
  Mostly to update readings from the DL (for now).
  Queued instructions sent here also to avoid collision with timed requests. }
begin
  ExecuteQueue();
end;
procedure TForm6.ExecuteQueue();
var
   pieces: TStringList;
   result: AnsiString;
   ThisMomentLocal, ThisMomentUTC, UnitTime: TDateTime;
   ThisMomentLocalString, ThisMomentUTCString, UnitTimeString : String;
begin
   Timer1.Enabled:=False;
   pieces := TStringList.Create;
   pieces.Delimiter := ',';

   ThisMomentLocal:=Now;
   ThisMomentUTC:=LazSysUtils.NowUTC;
if (((SelectedModel=model_DL) or (SelectedModel=model_GPS) or (SelectedModel=model_V)or (SelectedModel=model_DLS))) then
   begin
     if DLQueue[0]='SetClock' then
        begin
            DLQueue[0]:='';
            StatusMessage('Setting unit clock...');
            result:=SendGet('LC'+FormatDateTime('yy-mm-dd ',ThisMomentUTC)+IntToStr(DayOfWeek(ThisMomentUTC))+FormatDateTime(' hh:nn:ss',ThisMomentUTC)+'x');
            { TODO 2 : check result }
        end
     else if DLQueue[0]='PauseClock' then
       begin
         DLQueue[0]:='';
         result:=SendGet('Lex');
       end
     else if DLQueue[0]='ResumeClock' then
       begin
         DLQueue[0]:='';
         result:=SendGet('LEx');
       end
     else
        begin
         result:=sendget('Lcx',False,3000,True,True); { Read the RTC, but do not log every reading }
          if Length(result)>=21 then
            begin
              //DLClockStringGrid.Cells[1,0]
              UnitTimeString:=FixDate(AnsiMidStr(Trim(result),4,19));
              UnitClockText.Text:=UnitTimeString;
              try
                 UnitTime:=ScanDateTime('yy-mm-dd hh:nn:ss',LeftStr(UnitTimeString,9)+RightStr(UnitTimeString,8));
              except
                    StatusMessage('Invalid RTC from device = '+UnitTimeString);
                    UnitTime:=ThisMomentUTC;
              end;
              //DLClockStringGrid.Cells[1,3]
              DifferenceTimeText.Text:=IntToStr(SecondsBetween(ThisMomentUTC,UnitTime));
            end
          else begin
            //DLClockStringGrid.Cells[1,0]
            UnitTimeString:='unknown';
            UnitClockText.Text:=UnitTimeString;
          end;
          //DLClockStringGrid.Cells[1,2]
          LocalTimeText.Text:=FormatDateTime('yy-mm-dd ddd hh:nn:ss',ThisMomentLocal);
          //DLClockStringGrid.Cells[1,1]
          UTCClockText.Text:=FormatDateTime('yy-mm-dd ddd hh:nn:ss',ThisMomentUTC);
          end;
     end
   else
       DLRefreshed:=False;

   Timer1.Enabled:=True;


end;

procedure TForm6.FormShow(Sender: TObject);
begin
  ExecuteQueue();
  Timer1.Enabled:=True;
end;

procedure TForm6.ResumClockButtonClick(Sender: TObject);
begin
  DLQueue[0]:='ResumeClock';
end;

procedure TForm6.SetDeviceClockClick(Sender: TObject);
begin
  DLQueue[0]:='SetClock';
end;

procedure TForm6.FormHide(Sender: TObject);
begin
  Timer1.Enabled:=False;
end;

procedure TForm6.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  Timer1.Enabled:=False;
end;

procedure TForm6.PauseClockButtonClick(Sender: TObject);
begin
  DLQueue[0]:='PauseClock';
end;

procedure TForm6.CloseButtonClick(Sender: TObject);
begin
  Form6.Close;
end;

procedure TForm6.FormCreate(Sender: TObject);
begin
   //DLClockStringGrid.Cells[0,0]:='Unit Clock';
   //DLClockStringGrid.Cells[0,1]:='UTC Clock';
   //DLClockStringGrid.Cells[0,2]:='Local time';
   //DLClockStringGrid.Cells[0,3]:='Difference';
   //DLClockStringGrid.Cells[2,3]:='seconds';
   //DLClockStringGrid.Font.Name:=FixedFont;
   UnitClockText.Font.Name:=FixedFont;
   UTCClockText.Font.Name:=FixedFont;
   LocalTimeText.Font.Name:=FixedFont;
   DifferenceTimeText.Font.Name:=FixedFont;
end;

initialization
  {$I dlclock.lrs}

end.

