.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSelectInput __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSelectInput \- select input events
.SH SYNTAX
.HP
int XSelectInput\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, long
\fIevent_mask\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIevent_mask\fP 1i
Specifies the event mask.
.IP \fIw\fP 1i
Specifies the window whose events you are interested in.
.SH DESCRIPTION
The
.B XSelectInput
function requests that the X server report the events associated with the
specified event mask.
Initially, X will not report any of these events.
Events are reported relative to a window.
If a window is not interested in a device event, it usually propagates to
the closest ancestor that is interested,
unless the do_not_propagate mask prohibits it.
.LP
Setting the event-mask attribute of a window overrides any previous call
for the same window but not for other clients.
Multiple clients can select for the same events on the same window
with the following restrictions:
.IP \(bu 5
Multiple clients can select events on the same window because their event masks
are disjoint.
When the X server generates an event, it reports it
to all interested clients.
.IP \(bu 5
Only one client at a time can select
.BR CirculateRequest ,
.BR ConfigureRequest ,
or
.B MapRequest
events, which are associated with
the event mask
.BR SubstructureRedirectMask .
.IP \(bu 5
Only one client at a time can select
a
.B ResizeRequest
event, which is associated with
the event mask
.BR ResizeRedirectMask .
.IP \(bu 5
Only one client at a time can select a
.B ButtonPress
event, which is associated with
the event mask
.BR ButtonPressMask .
.LP
The server reports the event to all interested clients.
.LP
.B XSelectInput
can generate a
.B BadWindow
error.
.SH DIAGNOSTICS
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
\fI\*(xL\fP
