/*
* File:    power10_events.h
* (C) Copyright IBM Corporation, 2021-2022.  All Rights Reserved.
* Author:  Will Schmidt
*          will_schmidt@vnet.ibm.com
* Author:  Carl Love
*          cel@us.ibm.com
#
* Content reworked May 11, 2022, - Will Schmidt.
* This file was automatically generated from event lists as
* provided by the IBM PowerPC PMU team.  Any manual
* updates should be clearly marked so they are not lost in
* any subsequent automatic rebuilds or refreshes of this file.
*
* Documentation on the PMU events for Power10 can be found
* in Appendix E of the Power10 Users Manual.
* The Power10 manual is at
*    https://ibm.ent.box.com/v/power10usermanual
* This and other PowerPC related documents can be found at
*    https://www-50.ibm.com/systems/power/openpower/
*/

#ifndef __POWER10_EVENTS_H__
#define __POWER10_EVENTS_H__


static const pme_power_entry_t power10_pe[] = {
	{.pme_name = "PM_1FLOP_CMPL",
	.pme_code = 0x45050,
	.pme_short_desc = "floating point;One floating point instruction completed (fadd, fmul, fsub, fcmp, fsel, fabs, fnabs, fres, fsqrte, fneg)",
	.pme_long_desc = "floating point;One floating point instruction completed (fadd, fmul, fsub, fcmp, fsel, fabs, fnabs, fres, fsqrte, fneg)",
	},
	{.pme_name = "PM_1PLUS_PPC_CMPL",
	.pme_code = 0x100F2,
	.pme_short_desc = "frontend;Cycles in which at least one instruction is completed by this thread",
	.pme_long_desc = "frontend;Cycles in which at least one instruction is completed by this thread",
	},
	{.pme_name = "PM_1PLUS_PPC_DISP",
	.pme_code = 0x400F2,
	.pme_short_desc = "pipeline;Cycles at least one Instr Dispatched",
	.pme_long_desc = "pipeline;Cycles at least one Instr Dispatched",
	},
	{.pme_name = "PM_2FLOP_CMPL",
	.pme_code = 0x4D052,
	.pme_short_desc = "floating point;Double Precision vector version of fmul, fsub, fcmp, fsel, fabs, fnabs, fres, fsqrte, fneg completed.",
	.pme_long_desc = "floating point;Double Precision vector version of fmul, fsub, fcmp, fsel, fabs, fnabs, fres, fsqrte, fneg completed.",
	},
	{.pme_name = "PM_4FLOP_CMPL",
	.pme_code = 0x45052,
	.pme_short_desc = "floating point;Four floating point instruction completed (fadd, fmul, fsub, fcmp, fsel, fabs, fnabs, fres, fsqrte, fneg)",
	.pme_long_desc = "floating point;Four floating point instruction completed (fadd, fmul, fsub, fcmp, fsel, fabs, fnabs, fres, fsqrte, fneg)",
	},
	{.pme_name = "PM_8FLOP_CMPL",
	.pme_code = 0x4D054,
	.pme_short_desc = "floating point;Four Double Precision vector instruction completed.",
	.pme_long_desc = "floating point;Four Double Precision vector instruction completed.",
	},
	{.pme_name = "PM_ADJUNCT_CYC",
	.pme_code = 0x10066,
	.pme_short_desc = "Cycles in which the thread is in Adjunct state.",
	.pme_long_desc = "Cycles in which the thread is in Adjunct state. MSR[S HV PR] bits = 011",
	},
	{.pme_name = "PM_ADJUNCT_INST_CMPL",
	.pme_code = 0x2E010,
	.pme_short_desc = "PowerPC instruction completed while the thread was in Adjunct state.",
	.pme_long_desc = "PowerPC instruction completed while the thread was in Adjunct state.",
	},
	{.pme_name = "PM_BR_CMPL",
	.pme_code = 0x4D05E,
	.pme_short_desc = "empty;A branch completed.",
	.pme_long_desc = "empty;A branch completed. All branches are included.",
	},
	{.pme_name = "PM_BR_FIN",
	.pme_code = 0x10068,
	.pme_short_desc = "pipeline;A branch instruction finished.",
	.pme_long_desc = "pipeline;A branch instruction finished. Includes predicted/mispredicted/unconditional",
	},
	{.pme_name = "PM_BR_FIN_ALT2",
	.pme_code = 0x2F04A,
	.pme_short_desc = "pipeline;A branch instruction finished.",
	.pme_long_desc = "pipeline;A branch instruction finished. Includes predicted/mispredicted/unconditional",
	},
	{.pme_name = "PM_BR_MPRED_CMPL",
	.pme_code = 0x400F6,
	.pme_short_desc = "cache;A mispredicted branch completed.",
	.pme_long_desc = "cache;A mispredicted branch completed. Includes direction and target.",
	},
	{.pme_name = "PM_BR_MPRED_NTKN_COND_DIR_GBHT",
	.pme_code = 0x000000E880,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using the Global Branch History Table.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using the Global Branch History Table. Resolved not taken",
	},
	{.pme_name = "PM_BR_MPRED_NTKN_COND_DIR_LBHT_GSEL",
	.pme_code = 0x000000E080,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using the Local Branch History Table selected with the global selector.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using the Local Branch History Table selected with the global selector. Resolved not taken",
	},
	{.pme_name = "PM_BR_MPRED_NTKN_COND_DIR_LBHT_LSEL",
	.pme_code = 0x00000058BC,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using the Local Branch History Table selected by the local selector.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using the Local Branch History Table selected by the local selector. Resolved not taken",
	},
	{.pme_name = "PM_BR_MPRED_NTKN_COND_DIR_TAGE",
	.pme_code = 0x000000E084,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using a TAGE override.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using a TAGE override. Resolved not taken",
	},
	{.pme_name = "PM_BR_MPRED_NTKN_COND_DIR_TOP",
	.pme_code = 0x000000E884,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using a TOP override to the BHT.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using a TOP override to the BHT. Resolved not taken",
	},
	{.pme_name = "PM_BR_MPRED_NTKN_SWHINT",
	.pme_code = 0x000000E0A0,
	.pme_short_desc = "NA;A software hinted branch finished and the branch resolved not taken and the hint was incorrect.",
	.pme_long_desc = "NA;A software hinted branch finished and the branch resolved not taken and the hint was incorrect.",
	},
	{.pme_name = "PM_BR_MPRED_TKN_COND_DIR_GBHT",
	.pme_code = 0x00000050B0,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using the Global Branch History Table.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using the Global Branch History Table. Resolved taken",
	},
	{.pme_name = "PM_BR_MPRED_TKN_COND_DIR_LBHT_GSEL",
	.pme_code = 0x00000058AC,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using the Local Branch History Table selected with the global selector.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using the Local Branch History Table selected with the global selector. Resolved taken",
	},
	{.pme_name = "PM_BR_MPRED_TKN_COND_DIR_LBHT_LSEL",
	.pme_code = 0x00000050AC,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using the Local Branch History Table selected by the local selector.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using the Local Branch History Table selected by the local selector. Resolved taken",
	},
	{.pme_name = "PM_BR_MPRED_TKN_COND_DIR_TAGE",
	.pme_code = 0x00000058B0,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using a TAGE override.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using a TAGE override. Resolved taken",
	},
	{.pme_name = "PM_BR_MPRED_TKN_COND_DIR_TOP",
	.pme_code = 0x00000050B4,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction using a TOP override to the BHT.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction using a TOP override to the BHT. Resolved taken",
	},
	{.pme_name = "PM_BR_MPRED_TKN_SWHINT",
	.pme_code = 0x000000E89C,
	.pme_short_desc = "NA;A software hinted branch finished and the branch resolved taken and the hint was incorrect.",
	.pme_long_desc = "NA;A software hinted branch finished and the branch resolved taken and the hint was incorrect.",
	},
	{.pme_name = "PM_BR_TAKEN_CMPL",
	.pme_code = 0x200FA,
	.pme_short_desc = "frontend;Branch Taken instruction completed",
	.pme_long_desc = "frontend;Branch Taken instruction completed",
	},
	{.pme_name = "PM_BR_TKN_UNCOND_FIN",
	.pme_code = 0x00000048B4,
	.pme_short_desc = "NA;An unconditional branch finished.",
	.pme_long_desc = "NA;An unconditional branch finished. All unconditional branches are taken.",
	},
	{.pme_name = "PM_CMPL_STALL_EXCEPTION",
	.pme_code = 0x3003A,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was not allowed to complete because it was interrupted by ANY exception, which has to be serviced before the instruction can complete",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was not allowed to complete because it was interrupted by ANY exception, which has to be serviced before the instruction can complete",
	},
	{.pme_name = "PM_CMPL_STALL_HWSYNC",
	.pme_code = 0x4D01A,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a hwsync waiting for response from L2 before completing.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a hwsync waiting for response from L2 before completing.",
	},
	{.pme_name = "PM_CMPL_STALL_LWSYNC",
	.pme_code = 0x1E05A,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a lwsync waiting to complete.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a lwsync waiting to complete.",
	},
	{.pme_name = "PM_CMPL_STALL_MEM_ECC",
	.pme_code = 0x30028,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for the non-speculative finish of either a STCX waiting for its result or a load waiting for non-critical sectors of data and ECC.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for the non-speculative finish of either a STCX waiting for its result or a load waiting for non-critical sectors of data and ECC.",
	},
	{.pme_name = "PM_CMPL_STALL_SPECIAL",
	.pme_code = 0x2C014,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline required special handling before completing.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline required special handling before completing.",
	},
	{.pme_name = "PM_CMPL_STALL_STCX",
	.pme_code = 0x2D01C,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a stcx waiting for resolution from the nest before completing.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a stcx waiting for resolution from the nest before completing.",
	},
	{.pme_name = "PM_CMPL_STALL",
	.pme_code = 0x4C018,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline cannot complete because the thread was blocked for any reason.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline cannot complete because the thread was blocked for any reason.",
	},
	{.pme_name = "PM_CYC",
	.pme_code = 0x100F0,
	.pme_short_desc = "pmc;Processor cycles",
	.pme_long_desc = "pmc;Processor cycles",
	},
	{.pme_name = "PM_CYC_ALT2",
	.pme_code = 0x2001E,
	.pme_short_desc = "pmc;Processor cycles",
	.pme_long_desc = "pmc;Processor cycles",
	},
	{.pme_name = "PM_CYC_ALT3",
	.pme_code = 0x3001E,
	.pme_short_desc = "pmc;Processor cycles",
	.pme_long_desc = "pmc;Processor cycles",
	},
	{.pme_name = "PM_CYC_ALT4",
	.pme_code = 0x4001E,
	.pme_short_desc = "pmc;Processor cycles",
	.pme_long_desc = "pmc;Processor cycles",
	},
	{.pme_name = "PM_DATA_FROM_DL2L3_MOD",
	.pme_code = 0x0E4240000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2L3_MOD_ALT2",
	.pme_code = 0x0E4240000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2L3_MOD_ALT3",
	.pme_code = 0x0E4240000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2L3_MOD_ALT4",
	.pme_code = 0x0E4240000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2L3_SHR",
	.pme_code = 0x0E0240000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2L3_SHR_ALT2",
	.pme_code = 0x0E0240000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2L3_SHR_ALT3",
	.pme_code = 0x0E0240000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2L3_SHR_ALT4",
	.pme_code = 0x0E0240000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2_MOD",
	.pme_code = 0x0E4040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2_MOD_ALT2",
	.pme_code = 0x0E4040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2_MOD_ALT3",
	.pme_code = 0x0E4040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2_MOD_ALT4",
	.pme_code = 0x0E4040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2_SHR",
	.pme_code = 0x0E0040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2_SHR_ALT2",
	.pme_code = 0x0E0040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2_SHR_ALT3",
	.pme_code = 0x0E0040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL2_SHR_ALT4",
	.pme_code = 0x0E0040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL3_MOD",
	.pme_code = 0x0EC040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL3_MOD_ALT2",
	.pme_code = 0x0EC040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL3_MOD_ALT3",
	.pme_code = 0x0EC040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL3_MOD_ALT4",
	.pme_code = 0x0EC040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL3_SHR",
	.pme_code = 0x0E8040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL3_SHR_ALT2",
	.pme_code = 0x0E8040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL3_SHR_ALT3",
	.pme_code = 0x0E8040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DL3_SHR_ALT4",
	.pme_code = 0x0E8040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DMEM",
	.pme_code = 0x0F4040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DMEM_ALT2",
	.pme_code = 0x0F4040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DMEM_ALT3",
	.pme_code = 0x0F4040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_DMEM_ALT4",
	.pme_code = 0x0F4040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_D_OC_CACHE",
	.pme_code = 0x0F8040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_D_OC_CACHE_ALT2",
	.pme_code = 0x0F8040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_D_OC_CACHE_ALT3",
	.pme_code = 0x0F8040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_D_OC_CACHE_ALT4",
	.pme_code = 0x0F8040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_D_OC_MEM",
	.pme_code = 0x0FC040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_D_OC_MEM_ALT2",
	.pme_code = 0x0FC040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_D_OC_MEM_ALT3",
	.pme_code = 0x0FC040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_D_OC_MEM_ALT4",
	.pme_code = 0x0FC040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_NON_REGENT_MOD",
	.pme_code = 0x0A4040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_NON_REGENT_MOD_ALT2",
	.pme_code = 0x0A4040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_NON_REGENT_MOD_ALT3",
	.pme_code = 0x0A4040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_NON_REGENT_MOD_ALT4",
	.pme_code = 0x0A4040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_NON_REGENT_SHR",
	.pme_code = 0x0A0040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_NON_REGENT_SHR_ALT2",
	.pme_code = 0x0A0040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_NON_REGENT_SHR_ALT3",
	.pme_code = 0x0A0040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_NON_REGENT_SHR_ALT4",
	.pme_code = 0x0A0040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_REGENT_MOD",
	.pme_code = 0x084040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_REGENT_MOD_ALT2",
	.pme_code = 0x084040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_REGENT_MOD_ALT3",
	.pme_code = 0x084040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_REGENT_MOD_ALT4",
	.pme_code = 0x084040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_REGENT_SHR",
	.pme_code = 0x080040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_REGENT_SHR_ALT2",
	.pme_code = 0x080040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_REGENT_SHR_ALT3",
	.pme_code = 0x080040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L21_REGENT_SHR_ALT4",
	.pme_code = 0x080040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L2MISS",
	.pme_code = 0x0003C0000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L2MISS_ALT2",
	.pme_code = 0x200FE,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L2MISS_ALT3",
	.pme_code = 0x0003C0000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L2MISS_ALT4",
	.pme_code = 0x0003C0000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L2",
	.pme_code = 0x000340000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L2_ALT2",
	.pme_code = 0x000340000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L2_ALT3",
	.pme_code = 0x000340000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L2_ALT4",
	.pme_code = 0x000340000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_NON_REGENT_MOD",
	.pme_code = 0x0AC040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_NON_REGENT_MOD_ALT2",
	.pme_code = 0x0AC040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_NON_REGENT_MOD_ALT3",
	.pme_code = 0x0AC040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_NON_REGENT_MOD_ALT4",
	.pme_code = 0x0AC040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_NON_REGENT_SHR",
	.pme_code = 0x0A8040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_NON_REGENT_SHR_ALT2",
	.pme_code = 0x0A8040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_NON_REGENT_SHR_ALT3",
	.pme_code = 0x0A8040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_NON_REGENT_SHR_ALT4",
	.pme_code = 0x0A8040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_REGENT_MOD",
	.pme_code = 0x08C040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_REGENT_MOD_ALT2",
	.pme_code = 0x08C040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_REGENT_MOD_ALT3",
	.pme_code = 0x08C040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_REGENT_MOD_ALT4",
	.pme_code = 0x08C040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_REGENT_SHR",
	.pme_code = 0x088040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_REGENT_SHR_ALT2",
	.pme_code = 0x088040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_REGENT_SHR_ALT3",
	.pme_code = 0x088040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L31_REGENT_SHR_ALT4",
	.pme_code = 0x088040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3_MEPF",
	.pme_code = 0x014040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3_MEPF_ALT2",
	.pme_code = 0x014040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3_MEPF_ALT3",
	.pme_code = 0x014040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3_MEPF_ALT4",
	.pme_code = 0x014040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3MISS",
	.pme_code = 0x0007C0000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3MISS_ALT2",
	.pme_code = 0x0007C0000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3MISS_ALT3",
	.pme_code = 0x300FE,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3MISS_ALT4",
	.pme_code = 0x0007C0000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3",
	.pme_code = 0x010340000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3_ALT2",
	.pme_code = 0x010340000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3_ALT3",
	.pme_code = 0x010340000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L3_ALT4",
	.pme_code = 0x010340000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_LMEM",
	.pme_code = 0x094040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_LMEM_ALT2",
	.pme_code = 0x094040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_LMEM_ALT3",
	.pme_code = 0x094040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_LMEM_ALT4",
	.pme_code = 0x094040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L_OC_CACHE",
	.pme_code = 0x098040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L_OC_CACHE_ALT2",
	.pme_code = 0x098040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L_OC_CACHE_ALT3",
	.pme_code = 0x098040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L_OC_CACHE_ALT4",
	.pme_code = 0x098040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L_OC_MEM",
	.pme_code = 0x09C040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L_OC_MEM_ALT2",
	.pme_code = 0x09C040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L_OC_MEM_ALT3",
	.pme_code = 0x09C040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_L_OC_MEM_ALT4",
	.pme_code = 0x09C040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_MEMORY",
	.pme_code = 0x400FE,
	.pme_short_desc = "The processor's data cache was reloaded from local, remote, or distant memory due to a demand miss",
	.pme_long_desc = "The processor's data cache was reloaded from local, remote, or distant memory due to a demand miss",
	},
	{.pme_name = "PM_DATA_FROM_RL2L3_MOD",
	.pme_code = 0x0C4240000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2L3_MOD_ALT2",
	.pme_code = 0x0C4240000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2L3_MOD_ALT3",
	.pme_code = 0x0C4240000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2L3_MOD_ALT4",
	.pme_code = 0x0C4240000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2L3_SHR",
	.pme_code = 0x0C0240000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2L3_SHR_ALT2",
	.pme_code = 0x0C0240000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2L3_SHR_ALT3",
	.pme_code = 0x0C0240000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2L3_SHR_ALT4",
	.pme_code = 0x0C0240000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 or L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2_MOD",
	.pme_code = 0x0C4040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2_MOD_ALT2",
	.pme_code = 0x0C4040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2_MOD_ALT3",
	.pme_code = 0x0C4040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2_MOD_ALT4",
	.pme_code = 0x0C4040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2_SHR",
	.pme_code = 0x0C0040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2_SHR_ALT2",
	.pme_code = 0x0C0040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2_SHR_ALT3",
	.pme_code = 0x0C0040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL2_SHR_ALT4",
	.pme_code = 0x0C0040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL3_MOD",
	.pme_code = 0x0CC040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL3_MOD_ALT2",
	.pme_code = 0x0CC040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL3_MOD_ALT3",
	.pme_code = 0x0CC040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL3_MOD_ALT4",
	.pme_code = 0x0CC040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL3_SHR",
	.pme_code = 0x0C8040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL3_SHR_ALT2",
	.pme_code = 0x0C8040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL3_SHR_ALT3",
	.pme_code = 0x0C8040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RL3_SHR_ALT4",
	.pme_code = 0x0C8040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RMEM",
	.pme_code = 0x0D4040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RMEM_ALT2",
	.pme_code = 0x0D4040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RMEM_ALT3",
	.pme_code = 0x0D4040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_RMEM_ALT4",
	.pme_code = 0x0D4040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_R_OC_CACHE",
	.pme_code = 0x0D8040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_R_OC_CACHE_ALT2",
	.pme_code = 0x0D8040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_R_OC_CACHE_ALT3",
	.pme_code = 0x0D8040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_R_OC_CACHE_ALT4",
	.pme_code = 0x0D8040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_R_OC_MEM",
	.pme_code = 0x0DC040000001C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_R_OC_MEM_ALT2",
	.pme_code = 0x0DC040000002C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_R_OC_MEM_ALT3",
	.pme_code = 0x0DC040000003C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DATA_FROM_R_OC_MEM_ALT4",
	.pme_code = 0x0DC040000004C040,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DC_RELOAD_COLLISIONS",
	.pme_code = 0x000000C0BC,
	.pme_short_desc = "NA;A load reading the L1 cache has a bank collision with another load reading the same bank, or due to a cache-line reload writing to that bank of the L1 cache.",
	.pme_long_desc = "NA;A load reading the L1 cache has a bank collision with another load reading the same bank, or due to a cache-line reload writing to that bank of the L1 cache.",
	},
	{.pme_name = "PM_DC_STORE_WRITE_COLLISIONS",
	.pme_code = 0x000000C8BC,
	.pme_short_desc = "NA;A store writing the L1 cache at the same time as a reload or dkill writing the L1 cache that results in a bank collision.",
	.pme_long_desc = "NA;A store writing the L1 cache at the same time as a reload or dkill writing the L1 cache that results in a bank collision.",
	},
	{.pme_name = "PM_DERAT_MISS_16G",
	.pme_code = 0x4C054,
	.pme_short_desc = "memory;Data ERAT Miss (Data TLB Access) page size 16G.",
	.pme_long_desc = "memory;Data ERAT Miss (Data TLB Access) page size 16G. When MMCR1[16]=0 this event counts only DERAT reloads for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DERAT_MISS_16M",
	.pme_code = 0x3C054,
	.pme_short_desc = "memory;Data ERAT Miss (Data TLB Access) page size 16M.",
	.pme_long_desc = "memory;Data ERAT Miss (Data TLB Access) page size 16M. When MMCR1[16]=0 this event counts only DERAT reloads for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DERAT_MISS_1G",
	.pme_code = 0x2C05A,
	.pme_short_desc = "memory;Data ERAT Miss (Data TLB Access) page size 1G.",
	.pme_long_desc = "memory;Data ERAT Miss (Data TLB Access) page size 1G. Implies radix translation. When MMCR1[16]=0 this event counts only DERAT reloads for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DERAT_MISS_2M",
	.pme_code = 0x1C05A,
	.pme_short_desc = "pipeline;Data ERAT Miss (Data TLB Access) page size 2M.",
	.pme_long_desc = "pipeline;Data ERAT Miss (Data TLB Access) page size 2M. Implies radix translation. When MMCR1[16]=0 this event counts only DERAT reloads for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DERAT_MISS_4K",
	.pme_code = 0x1C056,
	.pme_short_desc = "memory;Data ERAT Miss (Data TLB Access) page size 4K.",
	.pme_long_desc = "memory;Data ERAT Miss (Data TLB Access) page size 4K. When MMCR1[16]=0 this event counts only DERAT reloads for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DERAT_MISS_64K",
	.pme_code = 0x2C054,
	.pme_short_desc = "memory;Data ERAT Miss (Data TLB Access) page size 64K.",
	.pme_long_desc = "memory;Data ERAT Miss (Data TLB Access) page size 64K. When MMCR1[16]=0 this event counts only DERAT reloads for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DERAT_MISS",
	.pme_code = 0x200F6,
	.pme_short_desc = "memory;DERAT Reloaded to satisfy a DERAT miss.",
	.pme_long_desc = "memory;DERAT Reloaded to satisfy a DERAT miss. All page sizes are counted by this event. When MMCR1[16]=0 this event counts only DERAT reloads for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DISP_SS0_2_INSTR_CYC",
	.pme_code = 0x1F056,
	.pme_short_desc = "Cycles in which Superslice 0 dispatches either 1 or 2 instructions",
	.pme_long_desc = "Cycles in which Superslice 0 dispatches either 1 or 2 instructions",
	},
	{.pme_name = "PM_DISP_SS0_4_INSTR_CYC",
	.pme_code = 0x3F054,
	.pme_short_desc = "Cycles in which Superslice 0 dispatches either 3 or 4 instructions",
	.pme_long_desc = "Cycles in which Superslice 0 dispatches either 3 or 4 instructions",
	},
	{.pme_name = "PM_DISP_SS0_8_INSTR_CYC",
	.pme_code = 0x3F056,
	.pme_short_desc = "Cycles in which Superslice 0 dispatches either 5, 6, 7 or 8 instructions",
	.pme_long_desc = "Cycles in which Superslice 0 dispatches either 5, 6, 7 or 8 instructions",
	},
	{.pme_name = "PM_DISP_SS1_2_INSTR_CYC",
	.pme_code = 0x2F054,
	.pme_short_desc = "Cycles in which Superslice 1 dispatches either 1 or 2 instructions",
	.pme_long_desc = "Cycles in which Superslice 1 dispatches either 1 or 2 instructions",
	},
	{.pme_name = "PM_DISP_SS1_4_INSTR_CYC",
	.pme_code = 0x2F056,
	.pme_short_desc = "Cycles in which Superslice 1 dispatches either 3 or 4 instructions",
	.pme_long_desc = "Cycles in which Superslice 1 dispatches either 3 or 4 instructions",
	},
	{.pme_name = "PM_DISP_STALL_BR_MPRED_IC_L2",
	.pme_code = 0x1003A,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from the local L2 after suffering a branch mispredict.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from the local L2 after suffering a branch mispredict.",
	},
	{.pme_name = "PM_DISP_STALL_BR_MPRED_IC_L3MISS",
	.pme_code = 0x4C010,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from sources beyond the local L3 after suffering a mispredicted branch.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from sources beyond the local L3 after suffering a mispredicted branch.",
	},
	{.pme_name = "PM_DISP_STALL_BR_MPRED_IC_L3",
	.pme_code = 0x2C01E,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from the local L3 after suffering a branch mispredict.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from the local L3 after suffering a branch mispredict.",
	},
	{.pme_name = "PM_DISP_STALL_BR_MPRED_ICMISS",
	.pme_code = 0x34058,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled after a mispredicted branch resulted in an instruction cache miss.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled after a mispredicted branch resulted in an instruction cache miss.",
	},
	{.pme_name = "PM_DISP_STALL_BR_MPRED",
	.pme_code = 0x4D01E,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled for this thread due to a mispredicted branch.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled for this thread due to a mispredicted branch.",
	},
	{.pme_name = "PM_DISP_STALL_CYC",
	.pme_code = 0x100F8,
	.pme_short_desc = "pipeline;Cycles the ICT has no itags assigned to this thread (no instructions were dispatched during these cycles).",
	.pme_long_desc = "pipeline;Cycles the ICT has no itags assigned to this thread (no instructions were dispatched during these cycles).",
	},
	{.pme_name = "PM_DISP_STALL_FETCH",
	.pme_code = 0x2E018,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled for this thread because Fetch was being held",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled for this thread because Fetch was being held",
	},
	{.pme_name = "PM_DISP_STALL_FLUSH",
	.pme_code = 0x30004,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled because of a flush that happened to an instruction(s) that was not yet next-to-complete (NTC).",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled because of a flush that happened to an instruction(s) that was not yet next-to-complete (NTC). PM_EXEC_STALL_NTC_FLUSH only includes instructions that were flushed after becoming NTC",
	},
	{.pme_name = "PM_DISP_STALL_HELD_CYC",
	.pme_code = 0x4E01A,
	.pme_short_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch for any reason",
	.pme_long_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch for any reason",
	},
	{.pme_name = "PM_DISP_STALL_HELD_HALT_CYC",
	.pme_code = 0x1D05E,
	.pme_short_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because of power management",
	.pme_long_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because of power management",
	},
	{.pme_name = "PM_DISP_STALL_HELD_ISSQ_FULL_CYC",
	.pme_code = 0x20006,
	.pme_short_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch due to Issue queue full.",
	.pme_long_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch due to Issue queue full. Includes issue queue and branch queue",
	},
	{.pme_name = "PM_DISP_STALL_HELD_OTHER_CYC",
	.pme_code = 0x10006,
	.pme_short_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch for any other reason",
	.pme_long_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch for any other reason",
	},
	{.pme_name = "PM_DISP_STALL_HELD_RENAME_CYC",
	.pme_code = 0x3D05C,
	.pme_short_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because the mapper/SRB was full.",
	.pme_long_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because the mapper/SRB was full. Includes GPR (count, link, tar), VSR, VMR, FPR and XVFC",
	},
	{.pme_name = "PM_DISP_STALL_HELD_SCOREBOARD_CYC",
	.pme_code = 0x30018,
	.pme_short_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch while waiting on the Scoreboard.",
	.pme_long_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch while waiting on the Scoreboard. This event combines VSCR and FPSCR together",
	},
	{.pme_name = "PM_DISP_STALL_HELD_STF_MAPPER_CYC",
	.pme_code = 0x1E050,
	.pme_short_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because the STF mapper/SRB was full.",
	.pme_long_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because the STF mapper/SRB was full. Includes GPR (count, link, tar), VSR, VMR, FPR",
	},
	{.pme_name = "PM_DISP_STALL_HELD_SYNC_CYC",
	.pme_code = 0x4003C,
	.pme_short_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because of a synchronizing instruction that requires the ICT to be empty before dispatch",
	.pme_long_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because of a synchronizing instruction that requires the ICT to be empty before dispatch",
	},
	{.pme_name = "PM_DISP_STALL_HELD_XVFC_MAPPER_CYC",
	.pme_code = 0x2E01A,
	.pme_short_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because the XVFC mapper/SRB was full",
	.pme_long_desc = "pipeline;Cycles in which the next-to-complete (NTC) instruction is held at dispatch because the XVFC mapper/SRB was full",
	},
	{.pme_name = "PM_DISP_STALL_IC_L2",
	.pme_code = 0x10064,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from the local L2.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from the local L2.",
	},
	{.pme_name = "PM_DISP_STALL_IC_L3MISS",
	.pme_code = 0x4E010,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from any source beyond the local L3.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from any source beyond the local L3.",
	},
	{.pme_name = "PM_DISP_STALL_IC_L3",
	.pme_code = 0x3E052,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from the local L3.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled while the instruction was fetched from the local L3.",
	},
	{.pme_name = "PM_DISP_STALL_IC_MISS",
	.pme_code = 0x2D01A,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled for this thread due to an instruction cache miss.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled for this thread due to an instruction cache miss.",
	},
	{.pme_name = "PM_DISP_STALL_IERAT_ONLY_MISS",
	.pme_code = 0x2C016,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled while waiting to resolve an instruction ERAT miss",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled while waiting to resolve an instruction ERAT miss",
	},
	{.pme_name = "PM_DISP_STALL_ITLB_MISS",
	.pme_code = 0x3000A,
	.pme_short_desc = "frontend;Cycles when dispatch was stalled while waiting to resolve an instruction TLB miss.",
	.pme_long_desc = "frontend;Cycles when dispatch was stalled while waiting to resolve an instruction TLB miss.",
	},
	{.pme_name = "PM_DISP_STALL_TRANSLATION",
	.pme_code = 0x10038,
	.pme_short_desc = "pipeline;Cycles when dispatch was stalled for this thread because the MMU was handling a translation miss.",
	.pme_long_desc = "pipeline;Cycles when dispatch was stalled for this thread because the MMU was handling a translation miss.",
	},
	{.pme_name = "PM_DPP_FLOP_CMPL",
	.pme_code = 0x4D05C,
	.pme_short_desc = "floating point;Double-Precision or Quad-Precision instruction completed",
	.pme_long_desc = "floating point;Double-Precision or Quad-Precision instruction completed",
	},
	{.pme_name = "PM_DPTEG_FROM_DL2_MOD",
	.pme_code = 0x0E4060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL2_MOD_ALT2",
	.pme_code = 0x0E4060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL2_MOD_ALT3",
	.pme_code = 0x0E4060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL2_MOD_ALT4",
	.pme_code = 0x0E4060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL2_SHR",
	.pme_code = 0x0E0060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL2_SHR_ALT2",
	.pme_code = 0x0E0060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL2_SHR_ALT3",
	.pme_code = 0x0E0060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL2_SHR_ALT4",
	.pme_code = 0x0E0060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL3_MOD",
	.pme_code = 0x0EC060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL3_MOD_ALT2",
	.pme_code = 0x0EC060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL3_MOD_ALT3",
	.pme_code = 0x0EC060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL3_MOD_ALT4",
	.pme_code = 0x0EC060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL3_SHR",
	.pme_code = 0x0E8060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL3_SHR_ALT2",
	.pme_code = 0x0E8060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL3_SHR_ALT3",
	.pme_code = 0x0E8060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DL3_SHR_ALT4",
	.pme_code = 0x0E8060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DMEM",
	.pme_code = 0x0F4060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DMEM_ALT2",
	.pme_code = 0x0F4060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DMEM_ALT3",
	.pme_code = 0x0F4060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_DMEM_ALT4",
	.pme_code = 0x0F4060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_D_OC_CACHE",
	.pme_code = 0x0F8060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_D_OC_CACHE_ALT2",
	.pme_code = 0x0F8060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_D_OC_CACHE_ALT3",
	.pme_code = 0x0F8060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_D_OC_CACHE_ALT4",
	.pme_code = 0x0F8060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_D_OC_MEM",
	.pme_code = 0x0FC060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_D_OC_MEM_ALT2",
	.pme_code = 0x0FC060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_D_OC_MEM_ALT3",
	.pme_code = 0x0FC060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_D_OC_MEM_ALT4",
	.pme_code = 0x0FC060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_NON_REGENT_MOD",
	.pme_code = 0x0A4060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_NON_REGENT_MOD_ALT2",
	.pme_code = 0x0A4060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_NON_REGENT_MOD_ALT3",
	.pme_code = 0x0A4060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_NON_REGENT_MOD_ALT4",
	.pme_code = 0x0A4060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_NON_REGENT_SHR",
	.pme_code = 0x0A0060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_NON_REGENT_SHR_ALT2",
	.pme_code = 0x0A0060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_NON_REGENT_SHR_ALT3",
	.pme_code = 0x0A0060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_NON_REGENT_SHR_ALT4",
	.pme_code = 0x0A0060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_REGENT_MOD",
	.pme_code = 0x084060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_REGENT_MOD_ALT2",
	.pme_code = 0x084060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_REGENT_MOD_ALT3",
	.pme_code = 0x084060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_REGENT_MOD_ALT4",
	.pme_code = 0x084060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_REGENT_SHR",
	.pme_code = 0x080060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_REGENT_SHR_ALT2",
	.pme_code = 0x080060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_REGENT_SHR_ALT3",
	.pme_code = 0x080060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L21_REGENT_SHR_ALT4",
	.pme_code = 0x080060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L2MISS",
	.pme_code = 0x0003E0000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L2MISS_ALT2",
	.pme_code = 0x0003E0000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L2MISS_ALT3",
	.pme_code = 0x0003E0000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L2MISS_ALT4",
	.pme_code = 0x0003E0000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L2",
	.pme_code = 0x000360000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L2_ALT2",
	.pme_code = 0x000360000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L2_ALT3",
	.pme_code = 0x000360000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L2_ALT4",
	.pme_code = 0x000360000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_NON_REGENT_MOD",
	.pme_code = 0x0AC060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_NON_REGENT_MOD_ALT2",
	.pme_code = 0x0AC060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_NON_REGENT_MOD_ALT3",
	.pme_code = 0x0AC060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_NON_REGENT_MOD_ALT4",
	.pme_code = 0x0AC060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_NON_REGENT_SHR",
	.pme_code = 0x0A8060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_NON_REGENT_SHR_ALT2",
	.pme_code = 0x0A8060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_NON_REGENT_SHR_ALT3",
	.pme_code = 0x0A8060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_NON_REGENT_SHR_ALT4",
	.pme_code = 0x0A8060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_REGENT_MOD",
	.pme_code = 0x08C060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_REGENT_MOD_ALT2",
	.pme_code = 0x08C060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_REGENT_MOD_ALT3",
	.pme_code = 0x08C060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_REGENT_MOD_ALT4",
	.pme_code = 0x08C060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_REGENT_SHR",
	.pme_code = 0x088060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_REGENT_SHR_ALT2",
	.pme_code = 0x088060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_REGENT_SHR_ALT3",
	.pme_code = 0x088060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L31_REGENT_SHR_ALT4",
	.pme_code = 0x088060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L3MISS",
	.pme_code = 0x0007E0000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L3MISS_ALT2",
	.pme_code = 0x0007E0000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L3MISS_ALT3",
	.pme_code = 0x0007E0000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L3MISS_ALT4",
	.pme_code = 0x0007E0000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L3",
	.pme_code = 0x010360000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L3_ALT2",
	.pme_code = 0x010360000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L3_ALT3",
	.pme_code = 0x010360000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L3_ALT4",
	.pme_code = 0x010360000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_LMEM",
	.pme_code = 0x094060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_LMEM_ALT2",
	.pme_code = 0x094060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_LMEM_ALT3",
	.pme_code = 0x094060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_LMEM_ALT4",
	.pme_code = 0x094060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L_OC_CACHE",
	.pme_code = 0x098060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L_OC_CACHE_ALT2",
	.pme_code = 0x098060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L_OC_CACHE_ALT3",
	.pme_code = 0x098060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L_OC_CACHE_ALT4",
	.pme_code = 0x098060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L_OC_MEM",
	.pme_code = 0x09C060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L_OC_MEM_ALT2",
	.pme_code = 0x09C060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L_OC_MEM_ALT3",
	.pme_code = 0x09C060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_L_OC_MEM_ALT4",
	.pme_code = 0x09C060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL2_MOD",
	.pme_code = 0x0C4060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL2_MOD_ALT2",
	.pme_code = 0x0C4060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL2_MOD_ALT3",
	.pme_code = 0x0C4060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL2_MOD_ALT4",
	.pme_code = 0x0C4060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL2_SHR",
	.pme_code = 0x0C0060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL2_SHR_ALT2",
	.pme_code = 0x0C0060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL2_SHR_ALT3",
	.pme_code = 0x0C0060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL2_SHR_ALT4",
	.pme_code = 0x0C0060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL3_MOD",
	.pme_code = 0x0CC060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL3_MOD_ALT2",
	.pme_code = 0x0CC060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL3_MOD_ALT3",
	.pme_code = 0x0CC060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL3_MOD_ALT4",
	.pme_code = 0x0CC060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL3_SHR",
	.pme_code = 0x0C8060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL3_SHR_ALT2",
	.pme_code = 0x0C8060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL3_SHR_ALT3",
	.pme_code = 0x0C8060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RL3_SHR_ALT4",
	.pme_code = 0x0C8060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RMEM",
	.pme_code = 0x0D4060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RMEM_ALT2",
	.pme_code = 0x0D4060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RMEM_ALT3",
	.pme_code = 0x0D4060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_RMEM_ALT4",
	.pme_code = 0x0D4060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_R_OC_CACHE",
	.pme_code = 0x0D8060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_R_OC_CACHE_ALT2",
	.pme_code = 0x0D8060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_R_OC_CACHE_ALT3",
	.pme_code = 0x0D8060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_R_OC_CACHE_ALT4",
	.pme_code = 0x0D8060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_R_OC_MEM",
	.pme_code = 0x0DC060000001C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_R_OC_MEM_ALT2",
	.pme_code = 0x0DC060000002C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_R_OC_MEM_ALT3",
	.pme_code = 0x0DC060000003C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DPTEG_FROM_R_OC_MEM_ALT4",
	.pme_code = 0x0DC060000004C040,
	.pme_short_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's data page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_DTLB_HIT",
	.pme_code = 0x1F054,
	.pme_short_desc = "frontend;The PTE required by the instruction was resident in the TLB (data TLB access).",
	.pme_long_desc = "frontend;The PTE required by the instruction was resident in the TLB (data TLB access). When MMCR1[16]=0 this event counts only demand hits. When MMCR1[16]=1 this event includes demand and prefetch. Applies to both HPT and RPT",
	},
	{.pme_name = "PM_DTLB_MISS_16G",
	.pme_code = 0x1C058,
	.pme_short_desc = "memory;Data TLB reload (after a miss) page size 16G.",
	.pme_long_desc = "memory;Data TLB reload (after a miss) page size 16G. When MMCR1[16]=0 this event counts only for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches.",
	},
	{.pme_name = "PM_DTLB_MISS_16M",
	.pme_code = 0x4C056,
	.pme_short_desc = "memory;Data TLB reload (after a miss) page size 16M.",
	.pme_long_desc = "memory;Data TLB reload (after a miss) page size 16M. When MMCR1[16]=0 this event counts only for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DTLB_MISS_1G",
	.pme_code = 0x4C05A,
	.pme_short_desc = "memory;Data TLB reload (after a miss) page size 1G.",
	.pme_long_desc = "memory;Data TLB reload (after a miss) page size 1G. Implies radix translation was used. When MMCR1[16]=0 this event counts only for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DTLB_MISS_2M",
	.pme_code = 0x1C05C,
	.pme_short_desc = "memory;Data TLB reload (after a miss) page size 2M.",
	.pme_long_desc = "memory;Data TLB reload (after a miss) page size 2M. Implies radix translation was used. When MMCR1[16]=0 this event counts only for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DTLB_MISS_4K",
	.pme_code = 0x2C056,
	.pme_short_desc = "memory;Data TLB reload (after a miss) page size 4K.",
	.pme_long_desc = "memory;Data TLB reload (after a miss) page size 4K. When MMCR1[16]=0 this event counts only for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DTLB_MISS_64K",
	.pme_code = 0x3C056,
	.pme_short_desc = "memory;Data TLB reload (after a miss) page size 64K.",
	.pme_long_desc = "memory;Data TLB reload (after a miss) page size 64K. When MMCR1[16]=0 this event counts only for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_DTLB_MISS",
	.pme_code = 0x300FC,
	.pme_short_desc = "memory;The DPTEG required for the load/store instruction in execution was missing from the TLB.",
	.pme_long_desc = "memory;The DPTEG required for the load/store instruction in execution was missing from the TLB. It includes pages of all sizes for demand and prefetch activity",
	},
	{.pme_name = "PM_EXEC_STALL_BRU",
	.pme_code = 0x4D018,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in the Branch unit.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in the Branch unit.",
	},
	{.pme_name = "PM_EXEC_STALL_DERAT_DTLB_MISS",
	.pme_code = 0x30016,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline suffered a TLB miss and waited for it resolve.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline suffered a TLB miss and waited for it resolve.",
	},
	{.pme_name = "PM_EXEC_STALL_DERAT_ONLY_MISS",
	.pme_code = 0x4C012,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline suffered an ERAT miss and waited for it resolve.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline suffered an ERAT miss and waited for it resolve.",
	},
	{.pme_name = "PM_EXEC_STALL_DMISS_L21_L31",
	.pme_code = 0x1E054,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from another core's L2 or L3 on the same chip.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from another core's L2 or L3 on the same chip.",
	},
	{.pme_name = "PM_EXEC_STALL_DMISS_L2L3_CONFLICT",
	.pme_code = 0x4C016,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from the local L2 or local L3, with a dispatch conflict.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from the local L2 or local L3, with a dispatch conflict.",
	},
	{.pme_name = "PM_EXEC_STALL_DMISS_L2L3_NOCONFLICT",
	.pme_code = 0x34054,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from the local L2 or local L3, without a dispatch conflict.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from the local L2 or local L3, without a dispatch conflict.",
	},
	{.pme_name = "PM_EXEC_STALL_DMISS_L2L3",
	.pme_code = 0x1003C,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from either the local L2 or local L3.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from either the local L2 or local L3.",
	},
	{.pme_name = "PM_EXEC_STALL_DMISS_L3MISS",
	.pme_code = 0x2C018,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from a source beyond the local L2 or local L3.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from a source beyond the local L2 or local L3.",
	},
	{.pme_name = "PM_EXEC_STALL_DMISS_LMEM",
	.pme_code = 0x30038,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from the local memory, local OpenCAPI cache, or local OpenCAPI memory.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from the local memory, local OpenCAPI cache, or local OpenCAPI memory.",
	},
	{.pme_name = "PM_EXEC_STALL_DMISS_OFF_CHIP",
	.pme_code = 0x2C01C,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from a remote chip.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from a remote chip.",
	},
	{.pme_name = "PM_EXEC_STALL_DMISS_OFF_NODE",
	.pme_code = 0x4C01A,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from a distant chip.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting for a load miss to resolve from a distant chip.",
	},
	{.pme_name = "PM_EXEC_STALL_FIN_AT_DISP",
	.pme_code = 0x10058,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline finished at dispatch and did not require execution in the LSU, BRU or VSU.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline finished at dispatch and did not require execution in the LSU, BRU or VSU.",
	},
	{.pme_name = "PM_EXEC_STALL_LOAD_FINISH",
	.pme_code = 0x34056,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was finishing a load after its data was reloaded from a data source beyond the local L1; cycles in which the LSU was processing an L1-hit; cycles in which the next-to-finish (NTF) instruction merged with another load in the LMQ; cycles in which the NTF instruction is waiting for a data reload for a load miss, but the data comes back with a non-NTF instruction.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was finishing a load after its data was reloaded from a data source beyond the local L1; cycles in which the LSU was processing an L1-hit; cycles in which the next-to-finish (NTF) instruction merged with another load in the LMQ; cycles in which the NTF instruction is waiting for a data reload for a load miss, but the data comes back with a non-NTF instruction.",
	},
	{.pme_name = "PM_EXEC_STALL_LOAD",
	.pme_code = 0x4D014,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a load instruction executing in the Load Store Unit.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a load instruction executing in the Load Store Unit.",
	},
	{.pme_name = "PM_EXEC_STALL_LSU",
	.pme_code = 0x2C010,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in the Load Store Unit.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in the Load Store Unit. This does not include simple fixed point instructions.",
	},
	{.pme_name = "PM_EXEC_STALL_NTC_FLUSH",
	.pme_code = 0x2E01E,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in any unit before it was flushed.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in any unit before it was flushed. Note that if the flush of the oldest instruction happens after finish, the cycles from dispatch to issue will be included in PM_DISP_STALL and the cycles from issue to finish will be included in PM_EXEC_STALL and its corresponding children. This event will also count cycles when the previous next-to-finish (NTF) instruction is still completing and the new NTF instruction is stalled at dispatch.",
	},
	{.pme_name = "PM_EXEC_STALL_PTESYNC",
	.pme_code = 0x4D016,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a PTESYNC instruction executing in the Load Store Unit.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a PTESYNC instruction executing in the Load Store Unit.",
	},
	{.pme_name = "PM_EXEC_STALL_SIMPLE_FX",
	.pme_code = 0x30036,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a simple fixed point instruction executing in the Load Store Unit.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a simple fixed point instruction executing in the Load Store Unit.",
	},
	{.pme_name = "PM_EXEC_STALL_STORE_MISS",
	.pme_code = 0x30026,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a store whose cache line was not resident in the L1 and was waiting for allocation of the missing line into the L1.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a store whose cache line was not resident in the L1 and was waiting for allocation of the missing line into the L1.",
	},
	{.pme_name = "PM_EXEC_STALL_STORE_PIPE",
	.pme_code = 0x1E056,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in the store unit.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in the store unit. This does not include cycles spent handling store misses, PTESYNC instructions or TLBIE instructions.",
	},
	{.pme_name = "PM_EXEC_STALL_STORE",
	.pme_code = 0x30014,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a store instruction executing in the Load Store Unit.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a store instruction executing in the Load Store Unit.",
	},
	{.pme_name = "PM_EXEC_STALL_TLBIEL",
	.pme_code = 0x4D01C,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a TLBIEL instruction executing in the Load Store Unit.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a TLBIEL instruction executing in the Load Store Unit. TLBIEL instructions have lower overhead than TLBIE instructions because they don't get set to the nest.",
	},
	{.pme_name = "PM_EXEC_STALL_TLBIE",
	.pme_code = 0x2E01C,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a TLBIE instruction executing in the Load Store Unit.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was a TLBIE instruction executing in the Load Store Unit.",
	},
	{.pme_name = "PM_EXEC_STALL_TRANSLATION",
	.pme_code = 0x10004,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline suffered a TLB miss or ERAT miss and waited for it to resolve.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline suffered a TLB miss or ERAT miss and waited for it to resolve.",
	},
	{.pme_name = "PM_EXEC_STALL",
	.pme_code = 0x30008,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting to finish in one of the execution units (BRU, LSU, VSU).",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was waiting to finish in one of the execution units (BRU, LSU, VSU). Only cycles between issue and finish are counted in this category.",
	},
	{.pme_name = "PM_EXEC_STALL_UNKNOWN",
	.pme_code = 0x4E012,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline completed without an ntf_type pulse.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline completed without an ntf_type pulse. The ntf_pulse was missed by the ISU because the next-to-finish (NTF) instruction finishes and completions came too close together.",
	},
	{.pme_name = "PM_EXEC_STALL_VSU",
	.pme_code = 0x2D018,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in the VSU (includes FXU, VSU, CRU).",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was executing in the VSU (includes FXU, VSU, CRU).",
	},
	{.pme_name = "PM_FLOP_CMPL",
	.pme_code = 0x100F4,
	.pme_short_desc = "floating point;Floating Point Operations Completed.",
	.pme_long_desc = "floating point;Floating Point Operations Completed. Includes any type. It counts once for each 1, 2, 4 or 8 flop instruction. Use PM_1|2|4|8_FLOP_CMPL events to count flops",
	},
	{.pme_name = "PM_FLUSH_COMPLETION",
	.pme_code = 0x30012,
	.pme_short_desc = "frontend;The instruction that was next to complete (oldest in the pipeline) did not complete because it suffered a flush",
	.pme_long_desc = "frontend;The instruction that was next to complete (oldest in the pipeline) did not complete because it suffered a flush",
	},
	{.pme_name = "PM_FLUSH_MPRED",
	.pme_code = 0x1005A,
	.pme_short_desc = "pipeline;A flush occurred due to a mispredicted branch.",
	.pme_long_desc = "pipeline;A flush occurred due to a mispredicted branch. Includes target and direction",
	},
	{.pme_name = "PM_FLUSH",
	.pme_code = 0x400F8,
	.pme_short_desc = "pipeline;Flush (any type)",
	.pme_long_desc = "pipeline;Flush (any type)",
	},
	{.pme_name = "PM_FMA_CMPL",
	.pme_code = 0x45054,
	.pme_short_desc = "empty;Two floating point instruction completed (FMA class of instructions: fmadd, fnmadd, fmsub, fnmsub).",
	.pme_long_desc = "empty;Two floating point instruction completed (FMA class of instructions: fmadd, fnmadd, fmsub, fnmsub). Scalar instructions only. ",
	},
	{.pme_name = "PM_FX_LSU_FIN",
	.pme_code = 0x1006A,
	.pme_short_desc = "pipeline;Simple fixed point instruction issued to the store unit.",
	.pme_long_desc = "pipeline;Simple fixed point instruction issued to the store unit. Measured at finish time",
	},
	{.pme_name = "PM_FXU_ISSUE",
	.pme_code = 0x40004,
	.pme_short_desc = "pipeline;A fixed point instruction was issued to the VSU.",
	.pme_long_desc = "pipeline;A fixed point instruction was issued to the VSU.",
	},
	{.pme_name = "PM_HYPERVISOR_CYC",
	.pme_code = 0x2000A,
	.pme_short_desc = "pmc;Cycles when the thread is in Hypervisor state.",
	.pme_long_desc = "pmc;Cycles when the thread is in Hypervisor state. MSR[S HV PR]=010",
	},
	{.pme_name = "PM_HYPERVISOR_INST_CMPL",
	.pme_code = 0x4D022,
	.pme_short_desc = "pmc;PowerPC instruction completed while the thread was in hypervisor state.",
	.pme_long_desc = "pmc;PowerPC instruction completed while the thread was in hypervisor state.",
	},
	{.pme_name = "PM_ICBI_FIN",
	.pme_code = 0x2F04C,
	.pme_short_desc = "An ICBI instruction finished",
	.pme_long_desc = "An ICBI instruction finished",
	},
	{.pme_name = "PM_IC_DEMAND_CYC",
	.pme_code = 0x10018,
	.pme_short_desc = "pipeline;Cycles in which an instruction reload is pending to satisfy a demand miss",
	.pme_long_desc = "pipeline;Cycles in which an instruction reload is pending to satisfy a demand miss",
	},
	{.pme_name = "PM_IC_MISS_CMPL",
	.pme_code = 0x45058,
	.pme_short_desc = "pipeline;Non-speculative instruction cache miss, counted at completion",
	.pme_long_desc = "pipeline;Non-speculative instruction cache miss, counted at completion",
	},
	{.pme_name = "PM_IERAT_MISS",
	.pme_code = 0x100F6,
	.pme_short_desc = "frontend;IERAT Reloaded to satisfy an IERAT miss.",
	.pme_long_desc = "frontend;IERAT Reloaded to satisfy an IERAT miss. All page sizes are counted by this event.",
	},
	{.pme_name = "PM_INST_CMPL",
	.pme_code = 0x100FE,
	.pme_short_desc = "pmc;PowerPC instruction completed",
	.pme_long_desc = "pmc;PowerPC instruction completed",
	},
	{.pme_name = "PM_INST_CMPL_ALT2",
	.pme_code = 0x20002,
	.pme_short_desc = "pmc;PowerPC instruction completed",
	.pme_long_desc = "pmc;PowerPC instruction completed",
	},
	{.pme_name = "PM_INST_CMPL_ALT3",
	.pme_code = 0x30002,
	.pme_short_desc = "pmc;PowerPC instruction completed",
	.pme_long_desc = "pmc;PowerPC instruction completed",
	},
	{.pme_name = "PM_INST_CMPL_ALT4",
	.pme_code = 0x40002,
	.pme_short_desc = "pmc;PowerPC instruction completed",
	.pme_long_desc = "pmc;PowerPC instruction completed",
	},
	{.pme_name = "PM_INST_FIN",
	.pme_code = 0x40030,
	.pme_short_desc = "pmc;Instruction finished",
	.pme_long_desc = "pmc;Instruction finished",
	},
	{.pme_name = "PM_INST_FROM_DMEM",
	.pme_code = 0x0F4100000001C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_DMEM_ALT2",
	.pme_code = 0x0F4100000002C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_DMEM_ALT3",
	.pme_code = 0x0F4100000003C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_DMEM_ALT4",
	.pme_code = 0x0F4100000004C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L2MISS",
	.pme_code = 0x000380000001C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L2MISS_ALT2",
	.pme_code = 0x000380000002C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L2MISS_ALT3",
	.pme_code = 0x000380000003C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L2MISS_ALT4",
	.pme_code = 0x000380000004C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L2",
	.pme_code = 0x000300000001C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L2_ALT2",
	.pme_code = 0x000300000002C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L2_ALT3",
	.pme_code = 0x000300000003C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L2_ALT4",
	.pme_code = 0x000300000004C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L3MISS",
	.pme_code = 0x000780000001C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L3MISS_ALT2",
	.pme_code = 0x000780000002C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L3MISS_ALT3",
	.pme_code = 0x300FA,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L3MISS_ALT4",
	.pme_code = 0x000780000004C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L3",
	.pme_code = 0x010300000001C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L3_ALT2",
	.pme_code = 0x010300000002C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L3_ALT3",
	.pme_code = 0x010300000003C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_L3_ALT4",
	.pme_code = 0x010300000004C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_LMEM",
	.pme_code = 0x094100000001C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_LMEM_ALT2",
	.pme_code = 0x094100000002C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_LMEM_ALT3",
	.pme_code = 0x094100000003C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_LMEM_ALT4",
	.pme_code = 0x094100000004C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_RMEM",
	.pme_code = 0x0D4100000001C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_RMEM_ALT2",
	.pme_code = 0x0D4100000002C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_RMEM_ALT3",
	.pme_code = 0x0D4100000003C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_INST_FROM_RMEM_ALT4",
	.pme_code = 0x0D4100000004C040,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_IOPS_DISP",
	.pme_code = 0x24050,
	.pme_short_desc = "frontend;Internal Operations dispatched.",
	.pme_long_desc = "frontend;Internal Operations dispatched. PM_IOPS_DISP / PM_INST_DISP will show the average number of internal operations per PowerPC instruction.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL2_MOD",
	.pme_code = 0x0E4020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL2_MOD_ALT2",
	.pme_code = 0x0E4020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL2_MOD_ALT3",
	.pme_code = 0x0E4020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL2_MOD_ALT4",
	.pme_code = 0x0E4020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL2_SHR",
	.pme_code = 0x0E0020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL2_SHR_ALT2",
	.pme_code = 0x0E0020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL2_SHR_ALT3",
	.pme_code = 0x0E0020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL2_SHR_ALT4",
	.pme_code = 0x0E0020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL3_MOD",
	.pme_code = 0x0EC020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL3_MOD_ALT2",
	.pme_code = 0x0EC020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL3_MOD_ALT3",
	.pme_code = 0x0EC020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL3_MOD_ALT4",
	.pme_code = 0x0EC020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL3_SHR",
	.pme_code = 0x0E8020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL3_SHR_ALT2",
	.pme_code = 0x0E8020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL3_SHR_ALT3",
	.pme_code = 0x0E8020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DL3_SHR_ALT4",
	.pme_code = 0x0E8020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DMEM",
	.pme_code = 0x0F4020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DMEM_ALT2",
	.pme_code = 0x0F4020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DMEM_ALT3",
	.pme_code = 0x0F4020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_DMEM_ALT4",
	.pme_code = 0x0F4020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from distant memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_D_OC_CACHE",
	.pme_code = 0x0F8020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_D_OC_CACHE_ALT2",
	.pme_code = 0x0F8020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_D_OC_CACHE_ALT3",
	.pme_code = 0x0F8020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_D_OC_CACHE_ALT4",
	.pme_code = 0x0F8020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_D_OC_MEM",
	.pme_code = 0x0FC020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_D_OC_MEM_ALT2",
	.pme_code = 0x0FC020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_D_OC_MEM_ALT3",
	.pme_code = 0x0FC020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_D_OC_MEM_ALT4",
	.pme_code = 0x0FC020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_NON_REGENT_MOD",
	.pme_code = 0x0A4020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_NON_REGENT_MOD_ALT2",
	.pme_code = 0x0A4020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_NON_REGENT_MOD_ALT3",
	.pme_code = 0x0A4020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_NON_REGENT_MOD_ALT4",
	.pme_code = 0x0A4020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_NON_REGENT_SHR",
	.pme_code = 0x0A0020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_NON_REGENT_SHR_ALT2",
	.pme_code = 0x0A0020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_NON_REGENT_SHR_ALT3",
	.pme_code = 0x0A0020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_NON_REGENT_SHR_ALT4",
	.pme_code = 0x0A0020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_REGENT_MOD",
	.pme_code = 0x084020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_REGENT_MOD_ALT2",
	.pme_code = 0x084020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_REGENT_MOD_ALT3",
	.pme_code = 0x084020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_REGENT_MOD_ALT4",
	.pme_code = 0x084020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_REGENT_SHR",
	.pme_code = 0x080020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_REGENT_SHR_ALT2",
	.pme_code = 0x080020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_REGENT_SHR_ALT3",
	.pme_code = 0x080020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L21_REGENT_SHR_ALT4",
	.pme_code = 0x080020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L2MISS",
	.pme_code = 0x0003A0000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L2MISS_ALT2",
	.pme_code = 0x0003A0000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L2MISS_ALT3",
	.pme_code = 0x0003A0000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L2MISS_ALT4",
	.pme_code = 0x0003A0000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a source beyond the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L2",
	.pme_code = 0x000320000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L2_ALT2",
	.pme_code = 0x000320000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L2_ALT3",
	.pme_code = 0x000320000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L2_ALT4",
	.pme_code = 0x000320000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L2 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_NON_REGENT_MOD",
	.pme_code = 0x0AC020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_NON_REGENT_MOD_ALT2",
	.pme_code = 0x0AC020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_NON_REGENT_MOD_ALT3",
	.pme_code = 0x0AC020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_NON_REGENT_MOD_ALT4",
	.pme_code = 0x0AC020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_NON_REGENT_SHR",
	.pme_code = 0x0A8020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_NON_REGENT_SHR_ALT2",
	.pme_code = 0x0A8020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_NON_REGENT_SHR_ALT3",
	.pme_code = 0x0A8020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_NON_REGENT_SHR_ALT4",
	.pme_code = 0x0A8020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_REGENT_MOD",
	.pme_code = 0x08C020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_REGENT_MOD_ALT2",
	.pme_code = 0x08C020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_REGENT_MOD_ALT3",
	.pme_code = 0x08C020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_REGENT_MOD_ALT4",
	.pme_code = 0x08C020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_REGENT_SHR",
	.pme_code = 0x088020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_REGENT_SHR_ALT2",
	.pme_code = 0x088020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_REGENT_SHR_ALT3",
	.pme_code = 0x088020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L31_REGENT_SHR_ALT4",
	.pme_code = 0x088020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L3MISS",
	.pme_code = 0x0007A0000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L3MISS_ALT2",
	.pme_code = 0x0007A0000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L3MISS_ALT3",
	.pme_code = 0x0007A0000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L3MISS_ALT4",
	.pme_code = 0x0007A0000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from beyond the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L3",
	.pme_code = 0x010320000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L3_ALT2",
	.pme_code = 0x010320000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L3_ALT3",
	.pme_code = 0x010320000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L3_ALT4",
	.pme_code = 0x010320000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local core's L3 due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_LMEM",
	.pme_code = 0x094020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_LMEM_ALT2",
	.pme_code = 0x094020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_LMEM_ALT3",
	.pme_code = 0x094020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_LMEM_ALT4",
	.pme_code = 0x094020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L_OC_CACHE",
	.pme_code = 0x098020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L_OC_CACHE_ALT2",
	.pme_code = 0x098020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L_OC_CACHE_ALT3",
	.pme_code = 0x098020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L_OC_CACHE_ALT4",
	.pme_code = 0x098020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L_OC_MEM",
	.pme_code = 0x09C020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L_OC_MEM_ALT2",
	.pme_code = 0x09C020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L_OC_MEM_ALT3",
	.pme_code = 0x09C020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_L_OC_MEM_ALT4",
	.pme_code = 0x09C020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL2_MOD",
	.pme_code = 0x0C4020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL2_MOD_ALT2",
	.pme_code = 0x0C4020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL2_MOD_ALT3",
	.pme_code = 0x0C4020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL2_MOD_ALT4",
	.pme_code = 0x0C4020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL2_SHR",
	.pme_code = 0x0C0020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL2_SHR_ALT2",
	.pme_code = 0x0C0020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL2_SHR_ALT3",
	.pme_code = 0x0C0020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL2_SHR_ALT4",
	.pme_code = 0x0C0020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL3_MOD",
	.pme_code = 0x0CC020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL3_MOD_ALT2",
	.pme_code = 0x0CC020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL3_MOD_ALT3",
	.pme_code = 0x0CC020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL3_MOD_ALT4",
	.pme_code = 0x0CC020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL3_SHR",
	.pme_code = 0x0C8020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL3_SHR_ALT2",
	.pme_code = 0x0C8020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL3_SHR_ALT3",
	.pme_code = 0x0C8020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RL3_SHR_ALT4",
	.pme_code = 0x0C8020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RMEM",
	.pme_code = 0x0D4020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RMEM_ALT2",
	.pme_code = 0x0D4020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RMEM_ALT3",
	.pme_code = 0x0D4020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_RMEM_ALT4",
	.pme_code = 0x0D4020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from remote memory (MC slow) due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_R_OC_CACHE",
	.pme_code = 0x0D8020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_R_OC_CACHE_ALT2",
	.pme_code = 0x0D8020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_R_OC_CACHE_ALT3",
	.pme_code = 0x0D8020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_R_OC_CACHE_ALT4",
	.pme_code = 0x0D8020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_R_OC_MEM",
	.pme_code = 0x0DC020000001C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_R_OC_MEM_ALT2",
	.pme_code = 0x0DC020000002C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_R_OC_MEM_ALT3",
	.pme_code = 0x0DC020000003C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_IPTEG_FROM_R_OC_MEM_ALT4",
	.pme_code = 0x0DC020000004C040,
	.pme_short_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;The processor's instruction page table entry was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	},
	{.pme_name = "PM_ISSUE_CANCEL",
	.pme_code = 0x2405E,
	.pme_short_desc = "frontend;An instruction issued and the issue was later cancelled.",
	.pme_long_desc = "frontend;An instruction issued and the issue was later cancelled. Only one cancel per PowerPC instruction",
	},
	{.pme_name = "PM_ISSUE_KILL",
	.pme_code = 0x40006,
	.pme_short_desc = "frontend;Cycles in which an instruction or group of instructions were cancelled after being issued.",
	.pme_long_desc = "frontend;Cycles in which an instruction or group of instructions were cancelled after being issued. This event increments once per occurance, regardless of how many instructions are included in the issue group",
	},
	{.pme_name = "PM_ISSUE_STALL",
	.pme_code = 0x20004,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was dispatched but not issued yet.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline was dispatched but not issued yet.",
	},
	{.pme_name = "PM_ISU_FLUSH_DISP",
	.pme_code = 0x0000002084,
	.pme_short_desc = "NA;Dispatch flushes occur when one thread is causing other threads to stall",
	.pme_long_desc = "NA;Dispatch flushes occur when one thread is causing other threads to stall",
	},
	{.pme_name = "PM_ISU_FLUSH",
	.pme_code = 0x0000002880,
	.pme_short_desc = "NA;All flushes initiated by the Instruction Sequencing Unit (ISU).",
	.pme_long_desc = "NA;All flushes initiated by the Instruction Sequencing Unit (ISU). Excludes LSU NTC+1 flushes",
	},
	{.pme_name = "PM_ITLB_HIT_1G",
	.pme_code = 0x3F046,
	.pme_short_desc = "frontend;Instruction TLB hit (IERAT reload) page size 1G, which implies Radix Page Table translation is in use.",
	.pme_long_desc = "frontend;Instruction TLB hit (IERAT reload) page size 1G, which implies Radix Page Table translation is in use. When MMCR1[17]=0 this event counts only for demand misses. When MMCR1[17]=1 this event includes demand misses and prefetches.",
	},
	{.pme_name = "PM_ITLB_HIT",
	.pme_code = 0x2001A,
	.pme_short_desc = "memory;The PTE required to translate the instruction address was resident in the TLB (instruction TLB access/IERAT reload).",
	.pme_long_desc = "memory;The PTE required to translate the instruction address was resident in the TLB (instruction TLB access/IERAT reload). Applies to both HPT and RPT. When MMCR1[17]=0 this event counts only for demand misses. When MMCR1[17]=1 this event includes demand misses and prefetches.",
	},
	{.pme_name = "PM_ITLB_MISS",
	.pme_code = 0x400FC,
	.pme_short_desc = "frontend;Instruction TLB reload (after a miss), all page sizes.",
	.pme_long_desc = "frontend;Instruction TLB reload (after a miss), all page sizes. Includes only demand misses.",
	},
	{.pme_name = "PM_L1_ICACHE_MISS",
	.pme_code = 0x200FD,
	.pme_short_desc = "Demand instruction cache miss",
	.pme_long_desc = "Demand instruction cache miss",
	},
	{.pme_name = "PM_L1_ICACHE_RELOADED_ALL",
	.pme_code = 0x40012,
	.pme_short_desc = "Counts all instruction cache reloads includes demand, prefetch, prefetch turned into demand and demand turned into prefetch",
	.pme_long_desc = "Counts all instruction cache reloads includes demand, prefetch, prefetch turned into demand and demand turned into prefetch",
	},
	{.pme_name = "PM_L1_ICACHE_RELOADED_PREF",
	.pme_code = 0x30068,
	.pme_short_desc = "Counts all instruction cache prefetch reloads (includes demand turned into prefetch)",
	.pme_long_desc = "Counts all instruction cache prefetch reloads (includes demand turned into prefetch)",
	},
	{.pme_name = "PM_L2_CASTOUT_MOD",
	.pme_code = 0x010000016080,
	.pme_short_desc = "NA;A line in an Exclusive (M,Mu,Me) state is evicted from the L2.",
	.pme_long_desc = "NA;A line in an Exclusive (M,Mu,Me) state is evicted from the L2. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_CASTOUT_SHR",
	.pme_code = 0x010000016880,
	.pme_short_desc = "NA;A line in a Shared (Tx,Sx) state is evicted from the L2.",
	.pme_long_desc = "NA;A line in a Shared (Tx,Sx) state is evicted from the L2. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_CO_USAGE",
	.pme_code = 0x060000026880,
	.pme_short_desc = "NA;Continuous 16 cycle (2to1) window where this signals rotates thru sampling each CO machine busy.",
	.pme_long_desc = "NA;Continuous 16 cycle (2to1) window where this signals rotates thru sampling each CO machine busy. PMU uses this wave to then do 16 cyc count to sample total number of machs running. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_DC_INV",
	.pme_code = 0x010000026880,
	.pme_short_desc = "NA;Data cache invalidates sent over the reload bus to the core.",
	.pme_long_desc = "NA;Data cache invalidates sent over the reload bus to the core. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_IC_INV",
	.pme_code = 0x010000026080,
	.pme_short_desc = "NA;Instruction cache invalidates sent over the reload bus to the core.",
	.pme_long_desc = "NA;Instruction cache invalidates sent over the reload bus to the core. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_INST",
	.pme_code = 0x000000036080,
	.pme_short_desc = "NA;All successful I-side-instruction-fetch (e.",
	.pme_long_desc = "NA;All successful I-side-instruction-fetch (e.g. i-demand, i-prefetch) dispatches for this thread. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ISIDE_DSIDE_ATTEMPT",
	.pme_code = 0x020000016080,
	.pme_short_desc = "NA;All D-side-Ld or I-side-instruction-fetch dispatch attempts for this thread.",
	.pme_long_desc = "NA;All D-side-Ld or I-side-instruction-fetch dispatch attempts for this thread. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ISIDE_DSIDE_FAIL_ADDR",
	.pme_code = 0x020000016880,
	.pme_short_desc = "NA;All D-side-Ld or I-side-instruction-fetch dispatch attempts for this thread that failed due to an address collision conflicts with an L2 machine already working on this line (e.",
	.pme_long_desc = "NA;All D-side-Ld or I-side-instruction-fetch dispatch attempts for this thread that failed due to an address collision conflicts with an L2 machine already working on this line (e.g. ld-hit-stq or Read-claim/Castout/Snoop machines). Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ISIDE_DSIDE_FAIL_OTHER",
	.pme_code = 0x020000026080,
	.pme_short_desc = "NA;All D-side-Ld or I-side-instruction-fetch dispatch attempts for this thread that failed due to reasons other than an address collision conflicts with an L2 machine (e.",
	.pme_long_desc = "NA;All D-side-Ld or I-side-instruction-fetch dispatch attempts for this thread that failed due to reasons other than an address collision conflicts with an L2 machine (e.g. Read-Claim/Snoop machine not available). Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ISIDE_DSIDE",
	.pme_code = 0x010000036080,
	.pme_short_desc = "NA;All successful D-side-Ld or I-side-instruction-fetch dispatches for this thread.",
	.pme_long_desc = "NA;All successful D-side-Ld or I-side-instruction-fetch dispatches for this thread. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_LD_DISP",
	.pme_code = 0x0F0000016080,
	.pme_short_desc = "NA;All successful D-side-Ld or I-side-instruction-fetch dispatches for this thread.",
	.pme_long_desc = "NA;All successful D-side-Ld or I-side-instruction-fetch dispatches for this thread. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_LD_HIT",
	.pme_code = 0x0F0000026080,
	.pme_short_desc = "NA;All successful D-side-Ld or I-side-instruction-fetch dispatches for this thread that were L2 hits.",
	.pme_long_desc = "NA;All successful D-side-Ld or I-side-instruction-fetch dispatches for this thread that were L2 hits. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_LD_MISS",
	.pme_code = 0x000000026080,
	.pme_short_desc = "NA;All successful D-Side Load dispatches for this thread that missed in the L2.",
	.pme_long_desc = "NA;All successful D-Side Load dispatches for this thread that missed in the L2. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_LD",
	.pme_code = 0x000000016080,
	.pme_short_desc = "NA;All successful D-side Load dispatches for this thread (L2 miss + L2 hits).",
	.pme_long_desc = "NA;All successful D-side Load dispatches for this thread (L2 miss + L2 hits). Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_LOC_GUESS_CORRECT",
	.pme_code = 0x040000016080,
	.pme_short_desc = "NA;L2 guess local (LNS) and guess was correct (ie data local).",
	.pme_long_desc = "NA;L2 guess local (LNS) and guess was correct (ie data local). Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_LOC_GUESS_WRONG",
	.pme_code = 0x040000016880,
	.pme_short_desc = "NA;L2 guess local (LNS) and guess was not correct (ie data not on chip).",
	.pme_long_desc = "NA;L2 guess local (LNS) and guess was not correct (ie data not on chip). Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_RC_USAGE",
	.pme_code = 0x060000016880,
	.pme_short_desc = "NA;Continuous 16 cycle (2to1) window where this signals rotates thru sampling each RC machine busy.",
	.pme_long_desc = "NA;Continuous 16 cycle (2to1) window where this signals rotates thru sampling each RC machine busy. PMU uses this wave to then do 16 cyc count to sample total number of machs running. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_SN_USAGE",
	.pme_code = 0x060000036880,
	.pme_short_desc = "NA;Continuous 16 cycle (2to1) window where this signals rotates thru sampling each SN machine busy.",
	.pme_long_desc = "NA;Continuous 16 cycle (2to1) window where this signals rotates thru sampling each SN machine busy. PMU uses this wave to then do 16 cyc count to sample total number of machs running. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ST_ATTEMPT",
	.pme_code = 0x020000036080,
	.pme_short_desc = "NA;All D-side store dispatch attempts for this thread.",
	.pme_long_desc = "NA;All D-side store dispatch attempts for this thread. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ST_DISP_FAIL_ADDR",
	.pme_code = 0x020000036880,
	.pme_short_desc = "NA;All D-side store dispatch attempts for this thread that failed due to address collision with L2 machine already working on this line (e.",
	.pme_long_desc = "NA;All D-side store dispatch attempts for this thread that failed due to address collision with L2 machine already working on this line (e.g. ld-hit-stq or Read-claim/Castout/Snoop machines). Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ST_DISP_FAIL_OTHER",
	.pme_code = 0x020000046080,
	.pme_short_desc = "NA;All D-side store dispatch attempts for this thread that failed due to reason other than address collision (e.",
	.pme_long_desc = "NA;All D-side store dispatch attempts for this thread that failed due to reason other than address collision (e.g. Read-Claim/Snoop machine not available). Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ST_DISP",
	.pme_code = 0x0F0000016880,
	.pme_short_desc = "NA;All successful D-side store dispatches for this thread.",
	.pme_long_desc = "NA;All successful D-side store dispatches for this thread. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ST_MISS",
	.pme_code = 0x000000026880,
	.pme_short_desc = "NA;All successful D-Side Store dispatches for this thread that missed in the L2.",
	.pme_long_desc = "NA;All successful D-Side Store dispatches for this thread that missed in the L2. Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ST",
	.pme_code = 0x000000016880,
	.pme_short_desc = "NA;All successful D-side store dispatches for this thread (L2 miss + L2 hits).",
	.pme_long_desc = "NA;All successful D-side store dispatches for this thread (L2 miss + L2 hits). Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L2_ST_ALT4",
	.pme_code = 0x010000046080,
	.pme_short_desc = "NA;All successful D-side store dispatches for this thread (L2 miss + L2 hits).",
	.pme_long_desc = "NA;All successful D-side store dispatches for this thread (L2 miss + L2 hits). Since the event happens in a 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L3_LD_HIT",
	.pme_code = 0x120000026080,
	.pme_short_desc = "NA;L3 Hits for for loads, but not stores.",
	.pme_long_desc = "NA;L3 Hits for for loads, but not stores. Any L2 load (but not store) that hits in the L3, including data load, instruction load or translate load. Since the event happens in the 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L3_LD_MISS",
	.pme_code = 0x120000026880,
	.pme_short_desc = "NA;L3 Misses for loads, but not stores.",
	.pme_long_desc = "NA;L3 Misses for loads, but not stores. Any L2 load (but not store) to the L3 that misses in the L3, including data load, instruction load or translate load. Since the event happens in the 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_L3_WI_USAGE",
	.pme_code = 0x140000016880,
	.pme_short_desc = "NA;Lifetime, sample of Write Inject machine 0 valid.",
	.pme_long_desc = "NA;Lifetime, sample of Write Inject machine 0 valid. Increments while Write Inject machine 0 is valid. Since the event happens in the 2:1 clock domain and is time-sliced across all 4 threads, the event count should be multiplied by 2.",
	},
	{.pme_name = "PM_LARX_FIN",
	.pme_code = 0x3C058,
	.pme_short_desc = "memory;Load and reserve instruction (LARX) finished.",
	.pme_long_desc = "memory;Load and reserve instruction (LARX) finished. LARX and STCX are instructions used to acquire a lock",
	},
	{.pme_name = "PM_LD_CMPL",
	.pme_code = 0x4003E,
	.pme_short_desc = "memory;Load instruction completed",
	.pme_long_desc = "memory;Load instruction completed",
	},
	{.pme_name = "PM_LD_DEMAND_MISS_L1_FIN",
	.pme_code = 0x400F0,
	.pme_short_desc = "empty;Load missed L1, counted at finish time",
	.pme_long_desc = "empty;Load missed L1, counted at finish time",
	},
	{.pme_name = "PM_LD_DEMAND_MISS_L1",
	.pme_code = 0x300F6,
	.pme_short_desc = "The L1 cache was reloaded with a line that fulfills a demand miss request.",
	.pme_long_desc = "The L1 cache was reloaded with a line that fulfills a demand miss request. Counted at reload time, before finish.",
	},
	{.pme_name = "PM_LD_HIT_L1",
	.pme_code = 0x1505E,
	.pme_short_desc = "Load finished without experiencing an L1 miss",
	.pme_long_desc = "Load finished without experiencing an L1 miss",
	},
	{.pme_name = "PM_LD_L3MISS_PEND_CYC",
	.pme_code = 0x10062,
	.pme_short_desc = "memory;Cycles in which an L3 miss was pending for this thread",
	.pme_long_desc = "memory;Cycles in which an L3 miss was pending for this thread",
	},
	{.pme_name = "PM_LD_MISS_L1",
	.pme_code = 0x3E054,
	.pme_short_desc = "frontend;Load missed L1, counted at finish time.",
	.pme_long_desc = "frontend;Load missed L1, counted at finish time. LMQ merges are not included in this count. i.e. if a load instruction misses on an address that is already allocated on the LMQ, this event will not increment for that load). Note that this count is per slice, so if a load spans multiple slices this event will increment multiple times for a single load.",
	},
	{.pme_name = "PM_LD_PREFETCH_CACHE_LINE_MISS",
	.pme_code = 0x1002C,
	.pme_short_desc = "The L1 cache was reloaded with a line that fulfills a prefetch request",
	.pme_long_desc = "The L1 cache was reloaded with a line that fulfills a prefetch request",
	},
	{.pme_name = "PM_LD_REF_L1",
	.pme_code = 0x100FC,
	.pme_short_desc = "empty;All L1 D cache load references counted at finish, gated by reject.",
	.pme_long_desc = "empty;All L1 D cache load references counted at finish, gated by reject. In P9 and earlier this event counted only cacheable loads but in P10 both cacheable and non-cacheable loads are included",
	},
	{.pme_name = "PM_LSU_FIN",
	.pme_code = 0x30066,
	.pme_short_desc = "pipeline;LSU Finished an internal operation (up to 4 per cycle)",
	.pme_long_desc = "pipeline;LSU Finished an internal operation (up to 4 per cycle)",
	},
	{.pme_name = "PM_LSU_LD0_FIN",
	.pme_code = 0x1000C,
	.pme_short_desc = "pipeline;LSU Finished an internal operation in LD0 port",
	.pme_long_desc = "pipeline;LSU Finished an internal operation in LD0 port",
	},
	{.pme_name = "PM_LSU_LD1_FIN",
	.pme_code = 0x2000E,
	.pme_short_desc = "pipeline;LSU Finished an internal operation in LD1 port",
	.pme_long_desc = "pipeline;LSU Finished an internal operation in LD1 port",
	},
	{.pme_name = "PM_LSU_ST0_FIN",
	.pme_code = 0x10012,
	.pme_short_desc = "pipeline;LSU Finished an internal operation in ST0 port",
	.pme_long_desc = "pipeline;LSU Finished an internal operation in ST0 port",
	},
	{.pme_name = "PM_LSU_ST1_FIN",
	.pme_code = 0x2D010,
	.pme_short_desc = "pipeline;LSU Finished an internal operation in ST1 port",
	.pme_long_desc = "pipeline;LSU Finished an internal operation in ST1 port",
	},
	{.pme_name = "PM_LSU_ST2_FIN",
	.pme_code = 0x3001A,
	.pme_short_desc = "pipeline;LSU Finished an internal operation in ST2 port",
	.pme_long_desc = "pipeline;LSU Finished an internal operation in ST2 port",
	},
	{.pme_name = "PM_LSU_ST3_FIN",
	.pme_code = 0x4C01E,
	.pme_short_desc = "pipeline;LSU Finished an internal operation in ST3 port",
	.pme_long_desc = "pipeline;LSU Finished an internal operation in ST3 port",
	},
	{.pme_name = "PM_LSU_ST4_FIN",
	.pme_code = 0x10014,
	.pme_short_desc = "pipeline;LSU Finished an internal operation in ST4 port",
	.pme_long_desc = "pipeline;LSU Finished an internal operation in ST4 port",
	},
	{.pme_name = "PM_LSU_ST5_FIN",
	.pme_code = 0x3F04A,
	.pme_short_desc = "LSU Finished an internal operation in ST2 port",
	.pme_long_desc = "LSU Finished an internal operation in ST2 port",
	},
	{.pme_name = "PM_MATH_FLOP_CMPL",
	.pme_code = 0x4505C,
	.pme_short_desc = "floating point;Math floating point instruction completed",
	.pme_long_desc = "floating point;Math floating point instruction completed",
	},
	{.pme_name = "PM_MEM_PREF",
	.pme_code = 0x2C058,
	.pme_short_desc = "Memory prefetch for this thread.",
	.pme_long_desc = "Memory prefetch for this thread. Includes instruction and data. This event count should be divided by two since the event is sourced from 2:1 clock domain.",
	},
	{.pme_name = "PM_MEM_READ",
	.pme_code = 0x10056,
	.pme_short_desc = "pipeline;Reads from Memory from this thread (includes data/inst/xlate/l1prefetch/inst prefetch).",
	.pme_long_desc = "pipeline;Reads from Memory from this thread (includes data/inst/xlate/l1prefetch/inst prefetch). This event count should be divided by two since the event is sourced from 2:1 clock domain.",
	},
	{.pme_name = "PM_MEM_RWITM",
	.pme_code = 0x3C05E,
	.pme_short_desc = "empty;Memory Read With Intent to Modify for this thread.",
	.pme_long_desc = "empty;Memory Read With Intent to Modify for this thread. This event count should be divided by two since the event is sourced from 2:1 clock domain.",
	},
	{.pme_name = "PM_MMA_ISSUED",
	.pme_code = 0x1000E,
	.pme_short_desc = "pipeline;MMA instruction issued",
	.pme_long_desc = "pipeline;MMA instruction issued",
	},
	{.pme_name = "PM_MPRED_BR_NTKN_COND_DIR",
	.pme_code = 0x00000048BC,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction. Resolved not taken",
	},
	{.pme_name = "PM_MPRED_BR_TKN_COND_DIR",
	.pme_code = 0x00000040BC,
	.pme_short_desc = "NA;A conditional branch finished with mispredicted direction.",
	.pme_long_desc = "NA;A conditional branch finished with mispredicted direction. Resolved taken",
	},
	{.pme_name = "PM_MRK_BR_CMPL",
	.pme_code = 0x2415C,
	.pme_short_desc = "marked;A marked branch completed.",
	.pme_long_desc = "marked;A marked branch completed. All branches are included.",
	},
	{.pme_name = "PM_MRK_BR_MPRED_CMPL",
	.pme_code = 0x301E4,
	.pme_short_desc = "marked;Marked Branch Mispredicted.",
	.pme_long_desc = "marked;Marked Branch Mispredicted. Includes direction and target",
	},
	{.pme_name = "PM_MRK_BR_TAKEN_CMPL",
	.pme_code = 0x101E2,
	.pme_short_desc = "marked;Marked Branch Taken instruction completed",
	.pme_long_desc = "marked;Marked Branch Taken instruction completed",
	},
	{.pme_name = "PM_MRK_BRU_FIN",
	.pme_code = 0x2013A,
	.pme_short_desc = "marked;Marked Branch instruction finished",
	.pme_long_desc = "marked;Marked Branch instruction finished",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_MOD_CYC",
	.pme_code = 0x0E4040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL2_MOD to obtain the average DL2_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_MOD_CYC_ALT2",
	.pme_code = 0x0E4040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL2_MOD to obtain the average DL2_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_MOD_CYC_ALT3",
	.pme_code = 0x0E4040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL2_MOD to obtain the average DL2_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_MOD_CYC_ALT4",
	.pme_code = 0x0E4040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL2_MOD to obtain the average DL2_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_MOD",
	.pme_code = 0x0E4040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_MOD_ALT2",
	.pme_code = 0x0E4040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_MOD_ALT3",
	.pme_code = 0x0E4040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_MOD_ALT4",
	.pme_code = 0x0E4040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_SHR_CYC",
	.pme_code = 0x0E0040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL2_SHR to obtain the average DL2_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_SHR_CYC_ALT2",
	.pme_code = 0x0E0040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL2_SHR to obtain the average DL2_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_SHR_CYC_ALT3",
	.pme_code = 0x0E0040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL2_SHR to obtain the average DL2_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_SHR_CYC_ALT4",
	.pme_code = 0x0E0040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL2_SHR to obtain the average DL2_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_SHR",
	.pme_code = 0x0E0040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_SHR_ALT2",
	.pme_code = 0x0E0040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_SHR_ALT3",
	.pme_code = 0x0E0040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL2_SHR_ALT4",
	.pme_code = 0x0E0040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_MOD_CYC",
	.pme_code = 0x0EC040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL3_MOD to obtain the average DL3_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_MOD_CYC_ALT2",
	.pme_code = 0x0EC040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL3_MOD to obtain the average DL3_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_MOD_CYC_ALT3",
	.pme_code = 0x0EC040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL3_MOD to obtain the average DL3_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_MOD_CYC_ALT4",
	.pme_code = 0x0EC040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL3_MOD to obtain the average DL3_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_MOD",
	.pme_code = 0x0EC040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_MOD_ALT2",
	.pme_code = 0x0EC040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_MOD_ALT3",
	.pme_code = 0x0EC040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_MOD_ALT4",
	.pme_code = 0x0EC040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_SHR_CYC",
	.pme_code = 0x0E8040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL3_SHR to obtain the average DL3_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_SHR_CYC_ALT2",
	.pme_code = 0x0E8040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL3_SHR to obtain the average DL3_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_SHR_CYC_ALT3",
	.pme_code = 0x0E8040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL3_SHR to obtain the average DL3_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_SHR_CYC_ALT4",
	.pme_code = 0x0E8040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DL3_SHR to obtain the average DL3_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_SHR",
	.pme_code = 0x0E8040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_SHR_ALT2",
	.pme_code = 0x0E8040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_SHR_ALT3",
	.pme_code = 0x0E8040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DL3_SHR_ALT4",
	.pme_code = 0x0E8040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a distant chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DMEM_CYC",
	.pme_code = 0x0F4040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from distant memory (MC slow) due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DMEM to obtain the average DMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DMEM_CYC_ALT2",
	.pme_code = 0x0F4040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from distant memory (MC slow) due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DMEM to obtain the average DMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DMEM_CYC_ALT3",
	.pme_code = 0x0F4040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from distant memory (MC slow) due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DMEM to obtain the average DMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DMEM_CYC_ALT4",
	.pme_code = 0x0F4040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from distant memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from distant memory (MC slow) due to a demand miss. Divide this count by PM_MRK_DATA_FROM_DMEM to obtain the average DMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DMEM",
	.pme_code = 0x0F4040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DMEM_ALT2",
	.pme_code = 0x0F4040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DMEM_ALT3",
	.pme_code = 0x0F4040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_DMEM_ALT4",
	.pme_code = 0x0F4040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from distant memory (MC slow) due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_CACHE_CYC",
	.pme_code = 0x0F8040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_D_OC_CACHE to obtain the average D_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_CACHE_CYC_ALT2",
	.pme_code = 0x0F8040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_D_OC_CACHE to obtain the average D_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_CACHE_CYC_ALT3",
	.pme_code = 0x0F8040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_D_OC_CACHE to obtain the average D_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_CACHE_CYC_ALT4",
	.pme_code = 0x0F8040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_D_OC_CACHE to obtain the average D_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_CACHE",
	.pme_code = 0x0F8040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_CACHE_ALT2",
	.pme_code = 0x0F8040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_CACHE_ALT3",
	.pme_code = 0x0F8040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_CACHE_ALT4",
	.pme_code = 0x0F8040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_MEM_CYC",
	.pme_code = 0x0FC040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_D_OC_MEM to obtain the average D_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_MEM_CYC_ALT2",
	.pme_code = 0x0FC040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_D_OC_MEM to obtain the average D_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_MEM_CYC_ALT3",
	.pme_code = 0x0FC040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_D_OC_MEM to obtain the average D_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_MEM_CYC_ALT4",
	.pme_code = 0x0FC040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a distant chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_D_OC_MEM to obtain the average D_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_MEM",
	.pme_code = 0x0FC040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_MEM_ALT2",
	.pme_code = 0x0FC040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_MEM_ALT3",
	.pme_code = 0x0FC040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_D_OC_MEM_ALT4",
	.pme_code = 0x0FC040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a distant chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_MOD_CYC",
	.pme_code = 0x0A4040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_NON_REGENT_MOD to obtain the average L21_NON_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_MOD_CYC_ALT2",
	.pme_code = 0x0A4040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_NON_REGENT_MOD to obtain the average L21_NON_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_MOD_CYC_ALT3",
	.pme_code = 0x0A4040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_NON_REGENT_MOD to obtain the average L21_NON_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_MOD_CYC_ALT4",
	.pme_code = 0x0A4040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_NON_REGENT_MOD to obtain the average L21_NON_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_MOD",
	.pme_code = 0x0A4040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_MOD_ALT2",
	.pme_code = 0x0A4040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_MOD_ALT3",
	.pme_code = 0x0A4040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_MOD_ALT4",
	.pme_code = 0x0A4040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_SHR_CYC",
	.pme_code = 0x0A0040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_NON_REGENT_SHR to obtain the average L21_NON_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_SHR_CYC_ALT2",
	.pme_code = 0x0A0040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_NON_REGENT_SHR to obtain the average L21_NON_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_SHR_CYC_ALT3",
	.pme_code = 0x0A0040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_NON_REGENT_SHR to obtain the average L21_NON_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_SHR_CYC_ALT4",
	.pme_code = 0x0A0040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_NON_REGENT_SHR to obtain the average L21_NON_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_SHR",
	.pme_code = 0x0A0040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_SHR_ALT2",
	.pme_code = 0x0A0040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_SHR_ALT3",
	.pme_code = 0x0A0040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_NON_REGENT_SHR_ALT4",
	.pme_code = 0x0A0040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_MOD_CYC",
	.pme_code = 0x084040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_REGENT_MOD to obtain the average L21_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_MOD_CYC_ALT2",
	.pme_code = 0x084040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_REGENT_MOD to obtain the average L21_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_MOD_CYC_ALT3",
	.pme_code = 0x084040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_REGENT_MOD to obtain the average L21_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_MOD_CYC_ALT4",
	.pme_code = 0x084040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_REGENT_MOD to obtain the average L21_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_MOD",
	.pme_code = 0x084040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_MOD_ALT2",
	.pme_code = 0x084040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_MOD_ALT3",
	.pme_code = 0x084040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_MOD_ALT4",
	.pme_code = 0x084040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_SHR_CYC",
	.pme_code = 0x080040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_REGENT_SHR to obtain the average L21_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_SHR_CYC_ALT2",
	.pme_code = 0x080040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_REGENT_SHR to obtain the average L21_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_SHR_CYC_ALT3",
	.pme_code = 0x080040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_REGENT_SHR to obtain the average L21_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_SHR_CYC_ALT4",
	.pme_code = 0x080040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L21_REGENT_SHR to obtain the average L21_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_SHR",
	.pme_code = 0x080040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_SHR_ALT2",
	.pme_code = 0x080040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_SHR_ALT3",
	.pme_code = 0x080040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L21_REGENT_SHR_ALT4",
	.pme_code = 0x080040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_CYC",
	.pme_code = 0x000340000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L2 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L2 to obtain the average L2 latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_CYC_ALT2",
	.pme_code = 0x000340000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L2 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L2 to obtain the average L2 latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_CYC_ALT3",
	.pme_code = 0x000340000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L2 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L2 to obtain the average L2 latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_CYC_ALT4",
	.pme_code = 0x000340000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L2 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L2 to obtain the average L2 latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_MEPF_CYC",
	.pme_code = 0x004040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L2_MEPF to obtain the average L2_MEPF latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_MEPF_CYC_ALT2",
	.pme_code = 0x004040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L2_MEPF to obtain the average L2_MEPF latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_MEPF_CYC_ALT3",
	.pme_code = 0x004040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L2_MEPF to obtain the average L2_MEPF latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_MEPF_CYC_ALT4",
	.pme_code = 0x004040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L2_MEPF to obtain the average L2_MEPF latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_MEPF",
	.pme_code = 0x004040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_MEPF_ALT2",
	.pme_code = 0x004040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_MEPF_ALT3",
	.pme_code = 0x004040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_MEPF_ALT4",
	.pme_code = 0x004040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2MISS",
	.pme_code = 0x0003C0000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2MISS_ALT2",
	.pme_code = 0x0003C0000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2MISS_ALT3",
	.pme_code = 0x0003C0000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2MISS_ALT4",
	.pme_code = 0x401E8,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a source beyond the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2",
	.pme_code = 0x000340000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_ALT2",
	.pme_code = 0x000340000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_ALT3",
	.pme_code = 0x000340000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L2_ALT4",
	.pme_code = 0x000340000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L2 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_MOD_CYC",
	.pme_code = 0x0AC040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_NON_REGENT_MOD to obtain the average L31_NON_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_MOD_CYC_ALT2",
	.pme_code = 0x0AC040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_NON_REGENT_MOD to obtain the average L31_NON_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_MOD_CYC_ALT3",
	.pme_code = 0x0AC040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_NON_REGENT_MOD to obtain the average L31_NON_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_MOD_CYC_ALT4",
	.pme_code = 0x0AC040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_NON_REGENT_MOD to obtain the average L31_NON_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_MOD",
	.pme_code = 0x0AC040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_MOD_ALT2",
	.pme_code = 0x0AC040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_MOD_ALT3",
	.pme_code = 0x0AC040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_MOD_ALT4",
	.pme_code = 0x0AC040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_SHR_CYC",
	.pme_code = 0x0A8040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_NON_REGENT_SHR to obtain the average L31_NON_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_SHR_CYC_ALT2",
	.pme_code = 0x0A8040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_NON_REGENT_SHR to obtain the average L31_NON_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_SHR_CYC_ALT3",
	.pme_code = 0x0A8040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_NON_REGENT_SHR to obtain the average L31_NON_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_SHR_CYC_ALT4",
	.pme_code = 0x0A8040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_NON_REGENT_SHR to obtain the average L31_NON_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_SHR",
	.pme_code = 0x0A8040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_SHR_ALT2",
	.pme_code = 0x0A8040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_SHR_ALT3",
	.pme_code = 0x0A8040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_NON_REGENT_SHR_ALT4",
	.pme_code = 0x0A8040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in a different regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_MOD_CYC",
	.pme_code = 0x08C040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_REGENT_MOD to obtain the average L31_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_MOD_CYC_ALT2",
	.pme_code = 0x08C040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_REGENT_MOD to obtain the average L31_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_MOD_CYC_ALT3",
	.pme_code = 0x08C040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_REGENT_MOD to obtain the average L31_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_MOD_CYC_ALT4",
	.pme_code = 0x08C040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_REGENT_MOD to obtain the average L31_REGENT_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_MOD",
	.pme_code = 0x08C040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_MOD_ALT2",
	.pme_code = 0x08C040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_MOD_ALT3",
	.pme_code = 0x08C040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_MOD_ALT4",
	.pme_code = 0x08C040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_SHR_CYC",
	.pme_code = 0x088040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_REGENT_SHR to obtain the average L31_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_SHR_CYC_ALT2",
	.pme_code = 0x088040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_REGENT_SHR to obtain the average L31_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_SHR_CYC_ALT3",
	.pme_code = 0x088040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_REGENT_SHR to obtain the average L31_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_SHR_CYC_ALT4",
	.pme_code = 0x088040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L31_REGENT_SHR to obtain the average L31_REGENT_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_SHR",
	.pme_code = 0x088040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_SHR_ALT2",
	.pme_code = 0x088040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_SHR_ALT3",
	.pme_code = 0x088040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L31_REGENT_SHR_ALT4",
	.pme_code = 0x088040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 on the same chip in the same regent due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_CYC",
	.pme_code = 0x010340000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L3 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L3 to obtain the average L3 latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_CYC_ALT2",
	.pme_code = 0x010340000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L3 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L3 to obtain the average L3 latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_CYC_ALT3",
	.pme_code = 0x010340000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L3 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L3 to obtain the average L3 latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_CYC_ALT4",
	.pme_code = 0x010340000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local core's L3 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L3 to obtain the average L3 latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_MEPF_CYC",
	.pme_code = 0x014040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L3_MEPF to obtain the average L3_MEPF latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_MEPF_CYC_ALT2",
	.pme_code = 0x014040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L3_MEPF to obtain the average L3_MEPF latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_MEPF_CYC_ALT3",
	.pme_code = 0x014040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L3_MEPF to obtain the average L3_MEPF latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_MEPF_CYC_ALT4",
	.pme_code = 0x014040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L3_MEPF to obtain the average L3_MEPF latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_MEPF",
	.pme_code = 0x014040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_MEPF_ALT2",
	.pme_code = 0x014040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_MEPF_ALT3",
	.pme_code = 0x014040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_MEPF_ALT4",
	.pme_code = 0x014040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with data in the MEPF state without dispatch conflicts from the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3MISS",
	.pme_code = 0x0007C0000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3MISS_ALT2",
	.pme_code = 0x201E4,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3MISS_ALT3",
	.pme_code = 0x0007C0000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3MISS_ALT4",
	.pme_code = 0x0007C0000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3",
	.pme_code = 0x010340000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_ALT2",
	.pme_code = 0x010340000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_ALT3",
	.pme_code = 0x010340000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L3_ALT4",
	.pme_code = 0x010340000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_LMEM_CYC",
	.pme_code = 0x094040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_LMEM to obtain the average LMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_LMEM_CYC_ALT2",
	.pme_code = 0x094040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_LMEM to obtain the average LMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_LMEM_CYC_ALT3",
	.pme_code = 0x094040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_LMEM to obtain the average LMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_LMEM_CYC_ALT4",
	.pme_code = 0x094040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_LMEM to obtain the average LMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_LMEM",
	.pme_code = 0x094040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_LMEM_ALT2",
	.pme_code = 0x094040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_LMEM_ALT3",
	.pme_code = 0x094040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_LMEM_ALT4",
	.pme_code = 0x094040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_CACHE_CYC",
	.pme_code = 0x098040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L_OC_CACHE to obtain the average L_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_CACHE_CYC_ALT2",
	.pme_code = 0x098040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L_OC_CACHE to obtain the average L_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_CACHE_CYC_ALT3",
	.pme_code = 0x098040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L_OC_CACHE to obtain the average L_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_CACHE_CYC_ALT4",
	.pme_code = 0x098040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L_OC_CACHE to obtain the average L_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_CACHE",
	.pme_code = 0x098040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_CACHE_ALT2",
	.pme_code = 0x098040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_CACHE_ALT3",
	.pme_code = 0x098040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_CACHE_ALT4",
	.pme_code = 0x098040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_MEM_CYC",
	.pme_code = 0x09C040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L_OC_MEM to obtain the average L_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_MEM_CYC_ALT2",
	.pme_code = 0x09C040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L_OC_MEM to obtain the average L_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_MEM_CYC_ALT3",
	.pme_code = 0x09C040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L_OC_MEM to obtain the average L_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_MEM_CYC_ALT4",
	.pme_code = 0x09C040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from the local chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_L_OC_MEM to obtain the average L_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_MEM",
	.pme_code = 0x09C040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_MEM_ALT2",
	.pme_code = 0x09C040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_MEM_ALT3",
	.pme_code = 0x09C040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_L_OC_MEM_ALT4",
	.pme_code = 0x09C040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from the local chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_MEMORY",
	.pme_code = 0x201E0,
	.pme_short_desc = "marked;The processor's data cache was reloaded from local, remote, or distant memory due to a demand miss for a marked load",
	.pme_long_desc = "marked;The processor's data cache was reloaded from local, remote, or distant memory due to a demand miss for a marked load",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_MOD_CYC",
	.pme_code = 0x0C4040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL2_MOD to obtain the average RL2_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_MOD_CYC_ALT2",
	.pme_code = 0x0C4040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL2_MOD to obtain the average RL2_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_MOD_CYC_ALT3",
	.pme_code = 0x0C4040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL2_MOD to obtain the average RL2_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_MOD_CYC_ALT4",
	.pme_code = 0x0C4040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL2_MOD to obtain the average RL2_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_MOD",
	.pme_code = 0x0C4040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_MOD_ALT2",
	.pme_code = 0x0C4040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_MOD_ALT3",
	.pme_code = 0x0C4040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_MOD_ALT4",
	.pme_code = 0x0C4040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_SHR_CYC",
	.pme_code = 0x0C0040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL2_SHR to obtain the average RL2_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_SHR_CYC_ALT2",
	.pme_code = 0x0C0040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL2_SHR to obtain the average RL2_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_SHR_CYC_ALT3",
	.pme_code = 0x0C0040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL2_SHR to obtain the average RL2_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_SHR_CYC_ALT4",
	.pme_code = 0x0C0040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL2_SHR to obtain the average RL2_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_SHR",
	.pme_code = 0x0C0040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_SHR_ALT2",
	.pme_code = 0x0C0040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_SHR_ALT3",
	.pme_code = 0x0C0040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL2_SHR_ALT4",
	.pme_code = 0x0C0040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L2 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_MOD_CYC",
	.pme_code = 0x0CC040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL3_MOD to obtain the average RL3_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_MOD_CYC_ALT2",
	.pme_code = 0x0CC040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL3_MOD to obtain the average RL3_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_MOD_CYC_ALT3",
	.pme_code = 0x0CC040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL3_MOD to obtain the average RL3_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_MOD_CYC_ALT4",
	.pme_code = 0x0CC040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL3_MOD to obtain the average RL3_MOD latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_MOD",
	.pme_code = 0x0CC040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_MOD_ALT2",
	.pme_code = 0x0CC040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_MOD_ALT3",
	.pme_code = 0x0CC040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_MOD_ALT4",
	.pme_code = 0x0CC040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a line in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_SHR_CYC",
	.pme_code = 0x0C8040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL3_SHR to obtain the average RL3_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_SHR_CYC_ALT2",
	.pme_code = 0x0C8040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL3_SHR to obtain the average RL3_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_SHR_CYC_ALT3",
	.pme_code = 0x0C8040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL3_SHR to obtain the average RL3_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_SHR_CYC_ALT4",
	.pme_code = 0x0C8040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RL3_SHR to obtain the average RL3_SHR latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_SHR",
	.pme_code = 0x0C8040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_SHR_ALT2",
	.pme_code = 0x0C8040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_SHR_ALT3",
	.pme_code = 0x0C8040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RL3_SHR_ALT4",
	.pme_code = 0x0C8040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded with a valid line that was not in the M (exclusive) state from another core's L3 from a remote chip due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RMEM_CYC",
	.pme_code = 0x0D4040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from remote memory (MC slow) due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RMEM to obtain the average RMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RMEM_CYC_ALT2",
	.pme_code = 0x0D4040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from remote memory (MC slow) due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RMEM to obtain the average RMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RMEM_CYC_ALT3",
	.pme_code = 0x0D4040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from remote memory (MC slow) due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RMEM to obtain the average RMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RMEM_CYC_ALT4",
	.pme_code = 0x0D4040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from remote memory (MC slow) due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from remote memory (MC slow) due to a demand miss. Divide this count by PM_MRK_DATA_FROM_RMEM to obtain the average RMEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RMEM",
	.pme_code = 0x0D4040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RMEM_ALT2",
	.pme_code = 0x0D4040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RMEM_ALT3",
	.pme_code = 0x0D4040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_RMEM_ALT4",
	.pme_code = 0x0D4040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from remote memory (MC slow) due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_CACHE_CYC",
	.pme_code = 0x0D8040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_R_OC_CACHE to obtain the average R_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_CACHE_CYC_ALT2",
	.pme_code = 0x0D8040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_R_OC_CACHE to obtain the average R_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_CACHE_CYC_ALT3",
	.pme_code = 0x0D8040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_R_OC_CACHE to obtain the average R_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_CACHE_CYC_ALT4",
	.pme_code = 0x0D8040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI cache due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI cache due to a demand miss. Divide this count by PM_MRK_DATA_FROM_R_OC_CACHE to obtain the average R_OC_CACHE latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_CACHE",
	.pme_code = 0x0D8040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_CACHE_ALT2",
	.pme_code = 0x0D8040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_CACHE_ALT3",
	.pme_code = 0x0D8040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_CACHE_ALT4",
	.pme_code = 0x0D8040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI cache due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_MEM_CYC",
	.pme_code = 0x0DC040000001C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_R_OC_MEM to obtain the average R_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_MEM_CYC_ALT2",
	.pme_code = 0x0DC040000002C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_R_OC_MEM to obtain the average R_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_MEM_CYC_ALT3",
	.pme_code = 0x0DC040000003C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_R_OC_MEM to obtain the average R_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_MEM_CYC_ALT4",
	.pme_code = 0x0DC040000004C144,
	.pme_short_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI memory due to a demand miss.",
	.pme_long_desc = "Data Source;Number of cycles when a marked instruction was waiting for a data cache miss that was reloaded from a remote chip's OpenCAPI memory due to a demand miss. Divide this count by PM_MRK_DATA_FROM_R_OC_MEM to obtain the average R_OC_MEM latency for data reloads.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_MEM",
	.pme_code = 0x0DC040000001C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_MEM_ALT2",
	.pme_code = 0x0DC040000002C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_MEM_ALT3",
	.pme_code = 0x0DC040000003C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DATA_FROM_R_OC_MEM_ALT4",
	.pme_code = 0x0DC040000004C142,
	.pme_short_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's L1 data cache was reloaded from a remote chip's OpenCAPI memory due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_DERAT_MISS_2M",
	.pme_code = 0x40164,
	.pme_short_desc = "marked;Data ERAT Miss (Data TLB Access) page size 2M for a marked instruction.",
	.pme_long_desc = "marked;Data ERAT Miss (Data TLB Access) page size 2M for a marked instruction. When MMCR1[16]=0 this event counts only DERAT reloads for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_MRK_DERAT_MISS_64K",
	.pme_code = 0x2D154,
	.pme_short_desc = "marked;Data ERAT Miss (Data TLB Access) page size 64K for a marked instruction.",
	.pme_long_desc = "marked;Data ERAT Miss (Data TLB Access) page size 64K for a marked instruction. When MMCR1[16]=0 this event counts only DERAT reloads for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_MRK_DFU_ISSUE",
	.pme_code = 0x20132,
	.pme_short_desc = "marked;The marked instruction was a decimal floating point operation issued to the VSU.",
	.pme_long_desc = "marked;The marked instruction was a decimal floating point operation issued to the VSU. Measured at issue time.",
	},
	{.pme_name = "PM_MRK_DTLB_MISS_64K",
	.pme_code = 0x4C15E,
	.pme_short_desc = "marked;Marked Data TLB reload (after a miss) page size 64K.",
	.pme_long_desc = "marked;Marked Data TLB reload (after a miss) page size 64K. When MMCR1[16]=0 this event counts only for demand misses. When MMCR1[16]=1 this event includes demand misses and prefetches",
	},
	{.pme_name = "PM_MRK_FX_LSU_FIN",
	.pme_code = 0x2013C,
	.pme_short_desc = "marked;The marked instruction was simple fixed point that was issued to the store unit.",
	.pme_long_desc = "marked;The marked instruction was simple fixed point that was issued to the store unit. Measured at finish time",
	},
	{.pme_name = "PM_MRK_FXU_ISSUE",
	.pme_code = 0x20134,
	.pme_short_desc = "marked;The marked instruction was a fixed point operation issued to the VSU.",
	.pme_long_desc = "marked;The marked instruction was a fixed point operation issued to the VSU. Measured at issue time.",
	},
	{.pme_name = "PM_MRK_INST_CMPL",
	.pme_code = 0x401E0,
	.pme_short_desc = "marked;Marked instruction completed",
	.pme_long_desc = "marked;Marked instruction completed",
	},
	{.pme_name = "PM_MRK_INST_DECODED",
	.pme_code = 0x20130,
	.pme_short_desc = "marked;An instruction was marked at decode time.",
	.pme_long_desc = "marked;An instruction was marked at decode time. Random Instruction Sampling (RIS) only",
	},
	{.pme_name = "PM_MRK_INST_DISP",
	.pme_code = 0x101E0,
	.pme_short_desc = "marked;The thread has dispatched a randomly sampled marked instruction",
	.pme_long_desc = "marked;The thread has dispatched a randomly sampled marked instruction",
	},
	{.pme_name = "PM_MRK_INST_FIN",
	.pme_code = 0x30130,
	.pme_short_desc = "marked;Marked instruction finished.",
	.pme_long_desc = "marked;Marked instruction finished. Excludes instructions that finish at dispatch. Note that stores always finish twice since the address gets issued to the LSU and the data gets issued to the VSU.",
	},
	{.pme_name = "PM_MRK_INST_FLUSHED",
	.pme_code = 0x4E15E,
	.pme_short_desc = "marked;The marked instruction was flushed",
	.pme_long_desc = "marked;The marked instruction was flushed",
	},
	{.pme_name = "PM_MRK_INST_FROM_L3MISS",
	.pme_code = 0x000780000001C142,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_INST_FROM_L3MISS_ALT2",
	.pme_code = 0x000780000002C142,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_INST_FROM_L3MISS_ALT3",
	.pme_code = 0x000780000003C142,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_INST_FROM_L3MISS_ALT4",
	.pme_code = 0x401E6,
	.pme_short_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	.pme_long_desc = "Data Source;The processor's instruction cache was reloaded from beyond the local core's L3 due to a demand miss for a marked instruction.",
	},
	{.pme_name = "PM_MRK_INST_ISSUED",
	.pme_code = 0x10132,
	.pme_short_desc = "marked;Marked instruction issued.",
	.pme_long_desc = "marked;Marked instruction issued. Note that stores always get issued twice, the address gets issued to the LSU and the data gets issued to the VSU. Also, issues can sometimes get killed/cancelled and cause multiple sequential issues for the same instruction.",
	},
	{.pme_name = "PM_MRK_INST_TIMEO",
	.pme_code = 0x40134,
	.pme_short_desc = "pmc;Marked instruction finish timeout (instruction was lost)",
	.pme_long_desc = "pmc;Marked instruction finish timeout (instruction was lost)",
	},
	{.pme_name = "PM_MRK_INST",
	.pme_code = 0x24158,
	.pme_short_desc = "marked;An instruction was marked.",
	.pme_long_desc = "marked;An instruction was marked. Includes both Random Instruction Sampling (RIS) at decode time and Random Event Sampling (RES) at the time the configured event happens",
	},
	{.pme_name = "PM_MRK_ISSUE_DEPENDENT_LOAD",
	.pme_code = 0x30162,
	.pme_short_desc = "marked;The marked instruction was dependent on a load.",
	.pme_long_desc = "marked;The marked instruction was dependent on a load. It is eligible for issue kill",
	},
	{.pme_name = "PM_MRK_L1_ICACHE_MISS",
	.pme_code = 0x101E4,
	.pme_short_desc = "marked;Marked instruction suffered an instruction cache miss",
	.pme_long_desc = "marked;Marked instruction suffered an instruction cache miss",
	},
	{.pme_name = "PM_MRK_L1_RELOAD_VALID",
	.pme_code = 0x101EA,
	.pme_short_desc = "marked;Marked demand reload",
	.pme_long_desc = "marked;Marked demand reload",
	},
	{.pme_name = "PM_MRK_L2_RC_DISP",
	.pme_code = 0x20114,
	.pme_short_desc = "marked;Marked instruction RC dispatched in L2",
	.pme_long_desc = "marked;Marked instruction RC dispatched in L2",
	},
	{.pme_name = "PM_MRK_L2_RC_DONE",
	.pme_code = 0x3012A,
	.pme_short_desc = "marked;L2 RC machine completed the transaction for the marked instruction",
	.pme_long_desc = "marked;L2 RC machine completed the transaction for the marked instruction",
	},
	{.pme_name = "PM_MRK_LARX_FIN",
	.pme_code = 0x40116,
	.pme_short_desc = "marked;Marked load and reserve instruction (LARX) finished.",
	.pme_long_desc = "marked;Marked load and reserve instruction (LARX) finished. LARX and STCX are instructions used to acquire a lock",
	},
	{.pme_name = "PM_MRK_LD_CMPL",
	.pme_code = 0x34146,
	.pme_short_desc = "marked;Marked load instruction completed",
	.pme_long_desc = "marked;Marked load instruction completed",
	},
	{.pme_name = "PM_MRK_LD_MISS_L1_CYC",
	.pme_code = 0x1D156,
	.pme_short_desc = "marked;Marked load latency.",
	.pme_long_desc = "marked;Marked load latency. The latency measured for this event counts between the original launch of a load L1 miss to the relaunch of that same load l1 miss once data is back from the nest and the load is going to finish",
	},
	{.pme_name = "PM_MRK_LD_MISS_L1",
	.pme_code = 0x201E2,
	.pme_short_desc = "marked;Marked demand data load miss counted at finish time",
	.pme_long_desc = "marked;Marked demand data load miss counted at finish time",
	},
	{.pme_name = "PM_MRK_LSU_FIN",
	.pme_code = 0x40132,
	.pme_short_desc = "marked;LSU marked instruction finish",
	.pme_long_desc = "marked;LSU marked instruction finish",
	},
	{.pme_name = "PM_MRK_NTF_CYC",
	.pme_code = 0x2011C,
	.pme_short_desc = "marked;Cycles in which the marked instruction is the oldest in the pipeline (next-to-finish or next-to-complete)",
	.pme_long_desc = "marked;Cycles in which the marked instruction is the oldest in the pipeline (next-to-finish or next-to-complete)",
	},
	{.pme_name = "PM_MRK_NTF_FIN",
	.pme_code = 0x20112,
	.pme_short_desc = "marked;The marked instruction became the oldest in the pipeline before it finished.",
	.pme_long_desc = "marked;The marked instruction became the oldest in the pipeline before it finished. It excludes instructions that finish at dispatch",
	},
	{.pme_name = "PM_MRK_START_PROBE_NOP_CMPL",
	.pme_code = 0x1F15E,
	.pme_short_desc = "pmc;Marked Start probe nop (AND R0,R0,R0) completed.",
	.pme_long_desc = "pmc;Marked Start probe nop (AND R0,R0,R0) completed.",
	},
	{.pme_name = "PM_MRK_START_PROBE_NOP_DISP",
	.pme_code = 0x40114,
	.pme_short_desc = "pmc;Marked Start probe nop dispatched.",
	.pme_long_desc = "pmc;Marked Start probe nop dispatched. Instruction AND R0,R0,R0",
	},
	{.pme_name = "PM_MRK_ST_CMPL",
	.pme_code = 0x301E2,
	.pme_short_desc = "marked;Marked store completed and sent to nest.",
	.pme_long_desc = "marked;Marked store completed and sent to nest. Note that this count excludes cache-inhibited stores",
	},
	{.pme_name = "PM_MRK_STCX_CORE_CYC",
	.pme_code = 0x44146,
	.pme_short_desc = "marked;Cycles spent in the core portion of a marked STCX instruction.",
	.pme_long_desc = "marked;Cycles spent in the core portion of a marked STCX instruction. It starts counting when the instruction is decoded and stops counting when it drains into the L2",
	},
	{.pme_name = "PM_MRK_STCX_FAIL",
	.pme_code = 0x3E158,
	.pme_short_desc = "marked;Marked conditional store instruction (STCX) failed.",
	.pme_long_desc = "marked;Marked conditional store instruction (STCX) failed. LARX and STCX are instructions used to acquire a lock ",
	},
	{.pme_name = "PM_MRK_STCX_FIN",
	.pme_code = 0x24156,
	.pme_short_desc = "marked;Marked conditional store instruction (STCX) finished.",
	.pme_long_desc = "marked;Marked conditional store instruction (STCX) finished. LARX and STCX are instructions used to acquire a lock",
	},
	{.pme_name = "PM_MRK_STCX_L2_CYC",
	.pme_code = 0x1F15C,
	.pme_short_desc = "marked;Cycles spent in the nest portion of a marked Stcx instruction.",
	.pme_long_desc = "marked;Cycles spent in the nest portion of a marked Stcx instruction. It starts counting when the operation starts to drain to the L2 and it stops counting when the instruction retires from the Instruction Completion Table (ICT) in the Instruction Sequencing Unit (ISU)",
	},
	{.pme_name = "PM_MRK_ST_DONE_L2",
	.pme_code = 0x10134,
	.pme_short_desc = "marked;Marked store completed in L2",
	.pme_long_desc = "marked;Marked store completed in L2",
	},
	{.pme_name = "PM_MRK_ST_DRAIN_CYC",
	.pme_code = 0x3F150,
	.pme_short_desc = "marked;Cycles in which the marked store drained from the core to the L2",
	.pme_long_desc = "marked;Cycles in which the marked store drained from the core to the L2",
	},
	{.pme_name = "PM_MRK_ST_FIN",
	.pme_code = 0x3E15A,
	.pme_short_desc = "marked;Marked store instruction finished",
	.pme_long_desc = "marked;Marked store instruction finished",
	},
	{.pme_name = "PM_MRK_ST_L2_CYC",
	.pme_code = 0x1F150,
	.pme_short_desc = "marked;Cycles from L2 RC dispatch to L2 RC completion",
	.pme_long_desc = "marked;Cycles from L2 RC dispatch to L2 RC completion",
	},
	{.pme_name = "PM_MRK_ST_NEST",
	.pme_code = 0x20138,
	.pme_short_desc = "marked;A store has been sampled/marked and is at the point of execution where it has completed in the core and can no longer be flushed.",
	.pme_long_desc = "marked;A store has been sampled/marked and is at the point of execution where it has completed in the core and can no longer be flushed. At this point the store is sent to the L2.",
	},
	{.pme_name = "PM_MRK_VSU_FIN",
	.pme_code = 0x30132,
	.pme_short_desc = "marked;VSU marked instruction finished.",
	.pme_long_desc = "marked;VSU marked instruction finished. Excludes simple FX instructions issued to the Store Unit.",
	},
	{.pme_name = "PM_MRK_XFER_FROM_SRC_CYC_PMC1",
	.pme_code = 0x1C144,
	.pme_short_desc = "marked;Cycles taken for a marked demand miss to reload a line from the source specified in MMCR3[0:12].",
	.pme_long_desc = "marked;Cycles taken for a marked demand miss to reload a line from the source specified in MMCR3[0:12].",
	},
	{.pme_name = "PM_MRK_XFER_FROM_SRC_CYC_PMC2",
	.pme_code = 0x2C144,
	.pme_short_desc = "marked;Cycles taken for a marked demand miss to reload a line from the source specified in MMCR3[15:27].",
	.pme_long_desc = "marked;Cycles taken for a marked demand miss to reload a line from the source specified in MMCR3[15:27].",
	},
	{.pme_name = "PM_MRK_XFER_FROM_SRC_CYC_PMC3",
	.pme_code = 0x3C144,
	.pme_short_desc = "marked;Cycles taken for a marked demand miss to reload a line from the source specified in MMCR3[30:42].",
	.pme_long_desc = "marked;Cycles taken for a marked demand miss to reload a line from the source specified in MMCR3[30:42].",
	},
	{.pme_name = "PM_MRK_XFER_FROM_SRC_CYC_PMC4",
	.pme_code = 0x4C144,
	.pme_short_desc = "marked;Cycles taken for a marked demand miss to reload a line from the source specified in MMCR3[45:57].",
	.pme_long_desc = "marked;Cycles taken for a marked demand miss to reload a line from the source specified in MMCR3[45:57].",
	},
	{.pme_name = "PM_MRK_XFER_FROM_SRC_PMC1",
	.pme_code = 0x1C142,
	.pme_short_desc = "marked;For a marked data transfer instruction, the processor's L1 data cache was reloaded from the source specified in MMCR3[0:12].",
	.pme_long_desc = "marked;For a marked data transfer instruction, the processor's L1 data cache was reloaded from the source specified in MMCR3[0:12]. If MMCR1[16|17] is 0 (default), this count includes only lines that were reloaded to satisfy a demand miss. If MMCR1[16|17] is 1, this count includes both demand misses and prefetch reloads.",
	},
	{.pme_name = "PM_MRK_XFER_FROM_SRC_PMC2",
	.pme_code = 0x2C142,
	.pme_short_desc = "marked;For a marked data transfer instruction, the processor's L1 data cache was reloaded from the source specified in MMCR3[15:27].",
	.pme_long_desc = "marked;For a marked data transfer instruction, the processor's L1 data cache was reloaded from the source specified in MMCR3[15:27]. If MMCR1[16|17] is 0 (default), this count includes only lines that were reloaded to satisfy a demand miss. If MMCR1[16|17] is 1, this count includes both demand misses and prefetch reloads.",
	},
	{.pme_name = "PM_MRK_XFER_FROM_SRC_PMC3",
	.pme_code = 0x3C142,
	.pme_short_desc = "marked;For a marked data transfer instruction, the processor's L1 data cache was reloaded from the source specified in MMCR3[30:42].",
	.pme_long_desc = "marked;For a marked data transfer instruction, the processor's L1 data cache was reloaded from the source specified in MMCR3[30:42]. If MMCR1[16|17] is 0 (default), this count includes only lines that were reloaded to satisfy a demand miss. If MMCR1[16|17] is 1, this count includes both demand misses and prefetch reloads.",
	},
	{.pme_name = "PM_MRK_XFER_FROM_SRC_PMC4",
	.pme_code = 0x4C142,
	.pme_short_desc = "marked;For a marked data transfer instruction, the processor's L1 data cache was reloaded from the source specified in MMCR3[45:57].",
	.pme_long_desc = "marked;For a marked data transfer instruction, the processor's L1 data cache was reloaded from the source specified in MMCR3[45:57]. If MMCR1[16|17] is 0 (default), this count includes only lines that were reloaded to satisfy a demand miss. If MMCR1[16|17] is 1, this count includes both demand misses and prefetch reloads.",
	},
	{.pme_name = "PM_NON_FMA_FLOP_CMPL",
	.pme_code = 0x4D056,
	.pme_short_desc = "floating point;Non FMA instruction completed",
	.pme_long_desc = "floating point;Non FMA instruction completed",
	},
	{.pme_name = "PM_NON_MATH_FLOP_CMPL",
	.pme_code = 0x4D05A,
	.pme_short_desc = "floating point;Non Math instruction completed",
	.pme_long_desc = "floating point;Non Math instruction completed",
	},
	{.pme_name = "PM_NTC_ALL_FIN",
	.pme_code = 0x40008,
	.pme_short_desc = "pipeline;Cycles in which both instructions in the ICT entry pair show as finished.",
	.pme_long_desc = "pipeline;Cycles in which both instructions in the ICT entry pair show as finished. These are the cycles between finish and completion for the oldest pair of instructions in the pipeline",
	},
	{.pme_name = "PM_NTC_FIN",
	.pme_code = 0x2405A,
	.pme_short_desc = "pipeline;Cycles in which the oldest instruction in the pipeline (NTC) finishes.",
	.pme_long_desc = "pipeline;Cycles in which the oldest instruction in the pipeline (NTC) finishes. Note that instructions can finish out of order, therefore not all the instructions that finish have a Next-to-complete status.",
	},
	{.pme_name = "PM_PMC1_OVERFLOW",
	.pme_code = 0x20010,
	.pme_short_desc = "pmc;The event selected for PMC1 caused the event counter to overflow.",
	.pme_long_desc = "pmc;The event selected for PMC1 caused the event counter to overflow.",
	},
	{.pme_name = "PM_PMC1_REWIND",
	.pme_code = 0x4D02C,
	.pme_short_desc = "pmc;The speculative event selected for PMC1 rewinds and the counter for PMC1 is not charged.",
	.pme_long_desc = "pmc;The speculative event selected for PMC1 rewinds and the counter for PMC1 is not charged.",
	},
	{.pme_name = "PM_PMC1_SAVED",
	.pme_code = 0x4D010,
	.pme_short_desc = "pmc;The conditions for the speculative event selected for PMC1 are met and PMC1 is charged.",
	.pme_long_desc = "pmc;The conditions for the speculative event selected for PMC1 are met and PMC1 is charged.",
	},
	{.pme_name = "PM_PMC2_OVERFLOW",
	.pme_code = 0x30010,
	.pme_short_desc = "pmc;The event selected for PMC2 caused the event counter to overflow.",
	.pme_long_desc = "pmc;The event selected for PMC2 caused the event counter to overflow.",
	},
	{.pme_name = "PM_PMC2_REWIND",
	.pme_code = 0x30020,
	.pme_short_desc = "pmc;The speculative event selected for PMC2 rewinds and the counter for PMC2 is not charged.",
	.pme_long_desc = "pmc;The speculative event selected for PMC2 rewinds and the counter for PMC2 is not charged.",
	},
	{.pme_name = "PM_PMC2_SAVED",
	.pme_code = 0x10022,
	.pme_short_desc = "pmc;The conditions for the speculative event selected for PMC2 are met and PMC2 is charged.",
	.pme_long_desc = "pmc;The conditions for the speculative event selected for PMC2 are met and PMC2 is charged.",
	},
	{.pme_name = "PM_PMC3_OVERFLOW",
	.pme_code = 0x40010,
	.pme_short_desc = "pmc;The event selected for PMC3 caused the event counter to overflow.",
	.pme_long_desc = "pmc;The event selected for PMC3 caused the event counter to overflow.",
	},
	{.pme_name = "PM_PMC3_REWIND",
	.pme_code = 0x1000A,
	.pme_short_desc = "pmc;The speculative event selected for PMC3 rewinds and the counter for PMC3 is not charged.",
	.pme_long_desc = "pmc;The speculative event selected for PMC3 rewinds and the counter for PMC3 is not charged.",
	},
	{.pme_name = "PM_PMC3_SAVED",
	.pme_code = 0x4D012,
	.pme_short_desc = "pmc;The conditions for the speculative event selected for PMC3 are met and PMC3 is charged.",
	.pme_long_desc = "pmc;The conditions for the speculative event selected for PMC3 are met and PMC3 is charged.",
	},
	{.pme_name = "PM_PMC4_OVERFLOW",
	.pme_code = 0x10010,
	.pme_short_desc = "pmc;The event selected for PMC4 caused the event counter to overflow.",
	.pme_long_desc = "pmc;The event selected for PMC4 caused the event counter to overflow.",
	},
	{.pme_name = "PM_PMC4_REWIND",
	.pme_code = 0x10020,
	.pme_short_desc = "pmc;The speculative event selected for PMC4 rewinds and the counter for PMC4 is not charged.",
	.pme_long_desc = "pmc;The speculative event selected for PMC4 rewinds and the counter for PMC4 is not charged.",
	},
	{.pme_name = "PM_PMC4_SAVED",
	.pme_code = 0x30022,
	.pme_short_desc = "pmc;The conditions for the speculative event selected for PMC4 are met and PMC4 is charged.",
	.pme_long_desc = "pmc;The conditions for the speculative event selected for PMC4 are met and PMC4 is charged.",
	},
	{.pme_name = "PM_PMC5_OVERFLOW",
	.pme_code = 0x10024,
	.pme_short_desc = "pmc;The event selected for PMC5 caused the event counter to overflow.",
	.pme_long_desc = "pmc;The event selected for PMC5 caused the event counter to overflow.",
	},
	{.pme_name = "PM_PMC6_OVERFLOW",
	.pme_code = 0x30024,
	.pme_short_desc = "pmc;The event selected for PMC6 caused the event counter to overflow.",
	.pme_long_desc = "pmc;The event selected for PMC6 caused the event counter to overflow.",
	},
	{.pme_name = "PM_PRIVILEGED_CYC",
	.pme_code = 0x4D028,
	.pme_short_desc = "pmc;Cycles when the thread is in Privileged state.",
	.pme_long_desc = "pmc;Cycles when the thread is in Privileged state. MSR[S HV PR]=x00",
	},
	{.pme_name = "PM_PRIVILEGED_INST_CMPL",
	.pme_code = 0x3405A,
	.pme_short_desc = "PowerPC instruction completed while the thread was in Privileged state.",
	.pme_long_desc = "PowerPC instruction completed while the thread was in Privileged state.",
	},
	{.pme_name = "PM_PTESYNC_FIN",
	.pme_code = 0x2003E,
	.pme_short_desc = "memory;Ptesync instruction finished in the store unit.",
	.pme_long_desc = "memory;Ptesync instruction finished in the store unit. Only one ptesync can finish at a time.",
	},
	{.pme_name = "PM_RUN_CYC_SMT2_MODE",
	.pme_code = 0x3006C,
	.pme_short_desc = "pmc;Cycles when this thread's run latch is set and the core is in SMT2 mode",
	.pme_long_desc = "pmc;Cycles when this thread's run latch is set and the core is in SMT2 mode",
	},
	{.pme_name = "PM_RUN_CYC_SMT4_MODE",
	.pme_code = 0x2006C,
	.pme_short_desc = "pmc;Cycles when this thread's run latch is set and the core is in SMT4 mode",
	.pme_long_desc = "pmc;Cycles when this thread's run latch is set and the core is in SMT4 mode",
	},
	{.pme_name = "PM_RUN_CYC_ST_MODE",
	.pme_code = 0x1006C,
	.pme_short_desc = "pmc;Cycles when the run latch is set and the core is in ST mode",
	.pme_long_desc = "pmc;Cycles when the run latch is set and the core is in ST mode",
	},
	{.pme_name = "PM_RUN_CYC",
	.pme_code = 0x200F4,
	.pme_short_desc = "pmc;Processor cycles gated by the run latch",
	.pme_long_desc = "pmc;Processor cycles gated by the run latch",
	},
	{.pme_name = "PM_RUN_INST_CMPL_CONC",
	.pme_code = 0x300F4,
	.pme_short_desc = "cache;PowerPC instruction completed by this thread when all threads in the core had the run-latch set",
	.pme_long_desc = "cache;PowerPC instruction completed by this thread when all threads in the core had the run-latch set",
	},
	{.pme_name = "PM_RUN_INST_CMPL",
	.pme_code = 0x400FA,
	.pme_short_desc = "pmc;PowerPC instruction completed while the run latch is set",
	.pme_long_desc = "pmc;PowerPC instruction completed while the run latch is set",
	},
	{.pme_name = "PM_RUN_LATCH_ALL_THREADS_CYC",
	.pme_code = 0x2000C,
	.pme_short_desc = "pmc;Cycles when the run latch is set for all threads.",
	.pme_long_desc = "pmc;Cycles when the run latch is set for all threads.",
	},
	{.pme_name = "PM_RUN_LATCH_ANY_THREAD_CYC",
	.pme_code = 0x100FA,
	.pme_short_desc = "pmc;Cycles when at least one thread has the run latch set",
	.pme_long_desc = "pmc;Cycles when at least one thread has the run latch set",
	},
	{.pme_name = "PM_SCALAR_FLOP_CMPL",
	.pme_code = 0x45056,
	.pme_short_desc = "floating point;Scalar floating point instruction completed.",
	.pme_long_desc = "floating point;Scalar floating point instruction completed.",
	},
	{.pme_name = "PM_SCALAR_FSQRT_FDIV_ISSUE",
	.pme_code = 0x3D058,
	.pme_short_desc = "pipeline;Scalar versions of four floating point operations: fdiv,fsqrt (xvdivdp, xvdivsp, xvsqrtdp, xvsqrtsp).",
	.pme_long_desc = "pipeline;Scalar versions of four floating point operations: fdiv,fsqrt (xvdivdp, xvdivsp, xvsqrtdp, xvsqrtsp).",
	},
	{.pme_name = "PM_SP_FLOP_CMPL",
	.pme_code = 0x4505A,
	.pme_short_desc = "floating point;Single Precision floating point instruction completed.",
	.pme_long_desc = "floating point;Single Precision floating point instruction completed.",
	},
	{.pme_name = "PM_ST_CMPL",
	.pme_code = 0x200F0,
	.pme_short_desc = "translation;Stores completed from S2Q (2nd-level store queue).",
	.pme_long_desc = "translation;Stores completed from S2Q (2nd-level store queue). This event includes regular stores, stcx and cache inhibited stores. The following operations are excluded (pteupdate, snoop tlbie complete, store atomics, miso, load atomic payloads, tlbie, tlbsync, slbieg, isync, msgsnd, slbiag, cpabort, copy, tcheck, tend, stsync, dcbst, icbi, dcbf, hwsync, lwsync, ptesync, eieio, msgsync)",
	},
	{.pme_name = "PM_STCX_FAIL_FIN",
	.pme_code = 0x1E058,
	.pme_short_desc = "locks;Conditional store instruction (STCX) failed.",
	.pme_long_desc = "locks;Conditional store instruction (STCX) failed. LARX and STCX are instructions used to acquire a lock ",
	},
	{.pme_name = "PM_STCX_FIN",
	.pme_code = 0x2E014,
	.pme_short_desc = "empty;Conditional store instruction (STCX) finished.",
	.pme_long_desc = "empty;Conditional store instruction (STCX) finished. LARX and STCX are instructions used to acquire a lock",
	},
	{.pme_name = "PM_STCX_PASS_FIN",
	.pme_code = 0x4E050,
	.pme_short_desc = "locks;Conditional store instruction (STCX) passed.",
	.pme_long_desc = "locks;Conditional store instruction (STCX) passed. LARX and STCX are instructions used to acquire a lock ",
	},
	{.pme_name = "PM_ST_FIN",
	.pme_code = 0x20016,
	.pme_short_desc = "translation;Store finish count.",
	.pme_long_desc = "translation;Store finish count. Includes speculative activity",
	},
	{.pme_name = "PM_ST_FWD",
	.pme_code = 0x20018,
	.pme_short_desc = "translation;Store forwards that finished",
	.pme_long_desc = "translation;Store forwards that finished",
	},
	{.pme_name = "PM_ST_MISS_L1",
	.pme_code = 0x300F0,
	.pme_short_desc = "translation;Store Missed L1",
	.pme_long_desc = "translation;Store Missed L1",
	},
	{.pme_name = "PM_THRESH_EXC_1024",
	.pme_code = 0x301EA,
	.pme_short_desc = "pmc;Threshold counter exceeded a value of 1024",
	.pme_long_desc = "pmc;Threshold counter exceeded a value of 1024",
	},
	{.pme_name = "PM_THRESH_EXC_128",
	.pme_code = 0x401EA,
	.pme_short_desc = "pmc;Threshold counter exceeded a value of 128",
	.pme_long_desc = "pmc;Threshold counter exceeded a value of 128",
	},
	{.pme_name = "PM_THRESH_EXC_256",
	.pme_code = 0x101E8,
	.pme_short_desc = "pmc;Threshold counter exceeded a count of 256",
	.pme_long_desc = "pmc;Threshold counter exceeded a count of 256",
	},
	{.pme_name = "PM_THRESH_EXC_32",
	.pme_code = 0x201E6,
	.pme_short_desc = "pmc;Threshold counter exceeded a value of 32",
	.pme_long_desc = "pmc;Threshold counter exceeded a value of 32",
	},
	{.pme_name = "PM_THRESH_EXC_512",
	.pme_code = 0x201E8,
	.pme_short_desc = "pmc;Threshold counter exceeded a value of 512",
	.pme_long_desc = "pmc;Threshold counter exceeded a value of 512",
	},
	{.pme_name = "PM_THRESH_EXC_64",
	.pme_code = 0x301E8,
	.pme_short_desc = "pmc;Threshold counter exceeded a value of 64",
	.pme_long_desc = "pmc;Threshold counter exceeded a value of 64",
	},
	{.pme_name = "PM_THRESH_MET",
	.pme_code = 0x101EC,
	.pme_short_desc = "pmc;Threshold exceeded",
	.pme_long_desc = "pmc;Threshold exceeded",
	},
	{.pme_name = "PM_TLBIE_FIN",
	.pme_code = 0x30058,
	.pme_short_desc = "pipeline;TLBIE instruction finished in the LSU.",
	.pme_long_desc = "pipeline;TLBIE instruction finished in the LSU. Two TLBIEs can finish each cycle. All will be counted",
	},
	{.pme_name = "PM_ULTRAVISOR_CYC",
	.pme_code = 0x4D026,
	.pme_short_desc = "pmc;Cycles when the thread is in Ultravisor state.",
	.pme_long_desc = "pmc;Cycles when the thread is in Ultravisor state. MSR[S HV PR]=110",
	},
	{.pme_name = "PM_ULTRAVISOR_INST_CMPL",
	.pme_code = 0x1001C,
	.pme_short_desc = "pmc;PowerPC instruction completed while the thread was in ultravisor state.",
	.pme_long_desc = "pmc;PowerPC instruction completed while the thread was in ultravisor state.",
	},
	{.pme_name = "PM_VECTOR_FLOP_CMPL",
	.pme_code = 0x4D058,
	.pme_short_desc = "floating point;Vector floating point instruction completed",
	.pme_long_desc = "floating point;Vector floating point instruction completed",
	},
	{.pme_name = "PM_VECTOR_LD_CMPL",
	.pme_code = 0x44054,
	.pme_short_desc = "empty;Vector load instruction completed",
	.pme_long_desc = "empty;Vector load instruction completed",
	},
	{.pme_name = "PM_VECTOR_ST_CMPL",
	.pme_code = 0x44056,
	.pme_short_desc = "frontend;Vector store instruction completed",
	.pme_long_desc = "frontend;Vector store instruction completed",
	},
	{.pme_name = "PM_VSU0_ISSUE",
	.pme_code = 0x10016,
	.pme_short_desc = "VSU instruction issued to VSU pipe 0",
	.pme_long_desc = "VSU instruction issued to VSU pipe 0",
	},
	{.pme_name = "PM_VSU1_ISSUE",
	.pme_code = 0x2D012,
	.pme_short_desc = "pipeline;VSU instruction issued to VSU pipe 1",
	.pme_long_desc = "pipeline;VSU instruction issued to VSU pipe 1",
	},
	{.pme_name = "PM_VSU2_ISSUE",
	.pme_code = 0x3F044,
	.pme_short_desc = "pipeline;VSU instruction issued to VSU pipe 2",
	.pme_long_desc = "pipeline;VSU instruction issued to VSU pipe 2",
	},
	{.pme_name = "PM_VSU3_ISSUE",
	.pme_code = 0x4D020,
	.pme_short_desc = "pipeline;VSU instruction was issued to VSU pipe 3",
	.pme_long_desc = "pipeline;VSU instruction was issued to VSU pipe 3",
	},
	{.pme_name = "PM_VSU_FIN",
	.pme_code = 0x4001C,
	.pme_short_desc = "empty;VSU instruction finished",
	.pme_long_desc = "empty;VSU instruction finished",
	},
	{.pme_name = "PM_VSU_ISSUE",
	.pme_code = 0x2505C,
	.pme_short_desc = "empty;At least one VSU instruction was issued to one of the VSU pipes.",
	.pme_long_desc = "empty;At least one VSU instruction was issued to one of the VSU pipes. Up to 4 per cycle. Includes fixed point operations.",
	},
	{.pme_name = "PM_VSU_NON_FLOP_CMPL",
	.pme_code = 0x4D050,
	.pme_short_desc = "floating point;Non-floating point VSU instruction completed",
	.pme_long_desc = "floating point;Non-floating point VSU instruction completed",
	},
	{.pme_name = "PM_XFER_FROM_SRC_PMC1",
	.pme_code = 0x1C040,
	.pme_short_desc = "memory;The processor's L1 data cache was reloaded from the source specified in MMCR3[0:12].",
	.pme_long_desc = "memory;The processor's L1 data cache was reloaded from the source specified in MMCR3[0:12]. If MMCR1[16|17] is 0 (default), this count includes only lines that were reloaded to satisfy a demand miss. If MMCR1[16|17] is 1, this count includes both demand misses and prefetch reloads.",
	},
	{.pme_name = "PM_XFER_FROM_SRC_PMC2",
	.pme_code = 0x2C040,
	.pme_short_desc = "memory;The processor's L1 data cache was reloaded from the source specified in MMCR3[15:27].",
	.pme_long_desc = "memory;The processor's L1 data cache was reloaded from the source specified in MMCR3[15:27]. If MMCR1[16|17] is 0 (default), this count includes only lines that were reloaded to satisfy a demand miss. If MMCR1[16|17] is 1, this count includes both demand misses and prefetch reloads.",
	},
	{.pme_name = "PM_XFER_FROM_SRC_PMC3",
	.pme_code = 0x3C040,
	.pme_short_desc = "memory;The processor's L1 data cache was reloaded from the source specified in MMCR3[30:42].",
	.pme_long_desc = "memory;The processor's L1 data cache was reloaded from the source specified in MMCR3[30:42]. If MMCR1[16|17] is 0 (default), this count includes only lines that were reloaded to satisfy a demand miss. If MMCR1[16|17] is 1, this count includes both demand misses and prefetch reloads.",
	},
	{.pme_name = "PM_XFER_FROM_SRC_PMC4",
	.pme_code = 0x4C040,
	.pme_short_desc = "memory;The processor's L1 data cache was reloaded from the source specified in MMCR3[45:57].",
	.pme_long_desc = "memory;The processor's L1 data cache was reloaded from the source specified in MMCR3[45:57]. If MMCR1[16|17] is 0 (default), this count includes only lines that were reloaded to satisfy a demand miss. If MMCR1[16|17] is 1, this count includes both demand misses and prefetch reloads.",
	},
/* total 949 */
};
#endif
