/* ----- encode/1277xfreeze3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1277xfreeze3_checksums[] = {
  "1b449bf6d1f970ca5d2339cd8f869e5b26d5116e35e464cfcc238d094b17f4d7",
  "200feb6191e1e49aa674353ac35d15ff8a3aa6c70cbcac515210a394bbaebddb",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1277xfreeze3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1277xfreeze3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1277xfreeze3_ITEMBYTES

static void *storage_encode_1277xfreeze3_s;
static unsigned char *test_encode_1277xfreeze3_s;
static void *storage_encode_1277xfreeze3_x;
static unsigned char *test_encode_1277xfreeze3_x;
static void *storage_encode_1277xfreeze3_s2;
static unsigned char *test_encode_1277xfreeze3_s2;
static void *storage_encode_1277xfreeze3_x2;
static unsigned char *test_encode_1277xfreeze3_x2;

#define precomputed_encode_1277xfreeze3_NUM 4

static const unsigned char precomputed_encode_1277xfreeze3_s[precomputed_encode_1277xfreeze3_NUM][crypto_encode_STRBYTES] = {
  {255,0,0,0,0,0,255,2,255,2,255,255,0,255,1,0,255,1,255,0,0,1,0,1,255,0,255,0,0,0,255,254,1,0,0,0,0,0,1,0,255,0,254,2,2,1,2,255,2,255,1,254,255,0,0,1,0,255,255,0,255,0,2,1,1,255,0,254,0,255,255,0,0,255,255,0,255,0,255,1,1,255,254,0,0,254,1,0,255,1,0,1,1,1,254,255,0,255,255,255,2,0,0,0,254,0,1,1,255,1,255,254,0,0,0,2,2,254,1,1,255,255,255,1,255,255,1,0,0,0,0,0,254,254,0,0,0,0,0,0,1,255,254,0,255,1,1,255,0,254,1,1,0,255,255,0,254,0,1,254,2,255,2,1,0,1,1,1,0,1,1,255,0,0,255,2,1,254,0,255,1,0,1,255,1,255,0,1,0,0,255,1,255,0,1,1,2,254,1,255,2,2,255,1,0,255,255,2,1,0,255,255,1,255,1,0,2,2,0,1,2,0,1,254,2,255,2,254,255,255,0,1,255,0,255,0,254,1,255,2,1,0,255,255,254,1,255,0,255,0,1,255,255,255,0,255,1,2,255,255,0,1,2,0,255,1,1,2,255,2,0,1,1,2,0,255,0,0,255,255,255,1,2,0,0,0,1,0,255,0,255,1,255,0,1,255,1,2,0,1,1,1,1,254,255,1,0,1,0,0,0,0,1,255,255,255,255,255,255,255,0,254,1,1,1,255,0,0,2,1,0,254,0,0,0,0,1,0,2,255,255,255,1,0,0,2,255,255,254,0,0,255,255,0,255,2,254,254,2,0,0,0,254,2,1,0,255,254,255,254,255,1,1,254,0,2,2,2,254,0,1,2,0,1,0,255,255,255,1,2,0,255,1,254,0,0,0,255,1,0,1,255,2,255,0,0,1,0,0,0,0,0,255,2,254,1,1,1,1,255,1,255,255,1,255,0,0,1,1,1,0,2,0,255,255,0,0,255,2,2,255,0,255,1,2,255,254,1,0,1,254,1,0,254,0,0,254,254,255,0,2,0,1,0,1,2,255,1,0,2,2,0,0,1,2,0,254,1,255,0,0,0,255,1,0,254,255,1,1,0,0,0,1,0,0,1,2,0,2,1,1,254,254,1,1,0,254,0,0,0,0,255,255,255,0,1,0,0,254,0,0,0,1,255,1,1,2,255,2,0,2,1,2,254,255,0,0,255,254,255,0,0,0,0,0,254,2,1,0,1,254,1,254,255,2,2,1,1,255,255,0,255,0,2,255,0,0,255,2,255,2,255,0,2,254,1,255,254,0,0,255,2,0,255,1,0,1,254,254,255,0,1,0,0,0,1,255,255,1,0,0,2,255,254,0,254,254,2,0,0,254,1,1,1,2,1,255,254,1,0,255,1,255,1,0,2,0,0,0,255,0,255,255,1,1,255,0,0,0,0,254,0,254,0,255,1,254,1,255,255,1,254,254,0,1,255,255,0,0,255,255,255,1,0,1,1,254,0,1,1,0,255,255,254,1,0,1,0,0,0,255,0,1,1,0,0,1,255,255,254,2,1,2,1,0,255,0,1,1,255,255,254,254,1,254,255,0,0,0,1,0,254,0,0,1,255,0,2,255,0,0,2,0,1,0,255,0,1,0,255,255,0,1,1,255,1,1,255,2,0,0,1,1,255,0,255,2,255,1,1,0,0,0,0,0,1,255,0,1,1,2,0,2,255,0,255,0,2,1,254,0,1,2,255,1,0,255,0,0,0,1,255,0,0,2,0,1,1,0,0,255,0,254,1,255,2,0,1,2,254,0,255,2,1,0,0,0,1,255,0,0,1,255,1,1,0,255,255,1,255,1,255,255,255,255,0,255,0,0,254,0,0,1,254,0,0,2,0,1,1,255,0,0,2,0,255,0,0,254,1,255,1,1,1,254,1,1,1,255,255,255,0,0,2,1,0,0,254,0,255,0,2,255,0,1,1,0,0,255,0,1,1,1,0,255,1,1,254,255,255,255,255,0,1,0,255,0,1,0,255,0,1,2,255,1,254,1,0,2,0,1,255,255,1,1,0,255,0,254,254,255,0,0,2,255,0,1,255,0,255,1,0,0,1,1,0,255,1,1,255,255,1,1,2,254,0,255,254,0,2,0,0,254,255,0,255,0,1,0,2,254,0,255,0,1,0,255,0,1,0,0,0,254,2,1,0,254,1,1,255,255,255,255,0,255,0,1,255,0,254,0,0,1,255,255,255,0,2,255,255,254,255,1,255,2,255,1,1,255,255,255,1,1,2,0,255,0,255,255,1,254,0,255,0,2,0,255,1,1,0,255,0,255,0,2,1,254,0,0,1,2,2,254,1,254,255,0,0,254,0,0,255,0,254,0,0,1,0,1,255,0,0,0,1,255,1,0,2,254,0,1,0,255,0,0,0,254,0,2,0,2,0,0,0,0,2,0,2,1,0,1,1,255,0,0,1,0,1,1,0,1,254,255,1,1,255,0,1,0,2,255,255,255,1,0,2,0,0,1,0,0,1,254,255,1,1,0,254,255,255,255,1,0,1,1,255,255,255,0,255,0,1,255,1,1,255,0,0,254,1,1,0,254,255,255,0,0,2,2,254,0,0,0,0,255,2,0,0,254,255,1,1,1,255,0,1,1,255,0,0,255,255,255,0,1,254,255,254,255,254,0,255,1,0,1,255,0,254,1,0,1,0,0,255,0,255,255,255,0,1,2,255,0,1,1,255,255,0,255,1,0,2,0,1,0,255,255,1,255,0,255,0,255,254,0,0,2,0,1,0,0,2,0,255,255,1,0,1,1,255,0,255,255,255,0,1,255,1,0,1,254,2,255,1,255,254,0,0,1,0,255,254,0,254,2,255,255},
  {1,0,254,0,1,2,2,255,2,2,2,255,255,255,1,0,0,1,0,2,255,1,2,255,1,0,254,255,0,1,255,1,2,255,2,0,255,1,0,0,255,0,254,254,255,0,0,0,0,255,0,1,0,1,1,0,1,0,0,1,255,254,1,1,254,1,0,0,0,1,254,255,0,255,0,2,1,0,2,1,2,255,0,0,0,255,1,0,0,0,2,0,0,254,255,0,0,1,2,2,1,1,0,0,0,0,1,1,1,1,255,255,0,255,1,255,2,1,0,1,255,1,0,1,1,1,1,255,0,1,0,254,1,2,255,0,2,1,0,0,1,1,255,1,255,1,1,255,1,255,1,1,0,1,1,254,255,1,255,0,0,1,1,1,1,1,1,255,255,255,0,0,0,0,254,0,254,1,1,255,254,0,255,0,2,255,0,255,254,0,1,1,255,0,255,2,0,1,255,254,255,255,0,1,1,0,255,0,0,1,254,0,254,0,0,254,1,0,1,1,0,1,254,0,1,1,254,254,254,2,0,255,0,1,1,255,255,0,2,255,1,0,0,0,0,0,255,0,255,1,0,254,1,255,0,255,0,0,0,1,0,255,0,255,1,255,255,0,255,0,255,0,255,1,255,0,1,255,0,1,0,1,255,1,0,2,1,0,0,1,0,0,255,1,0,254,1,0,0,0,1,0,1,0,254,255,255,0,2,1,0,255,1,0,1,0,1,2,0,255,0,254,1,1,255,255,255,0,254,2,2,0,2,0,255,255,0,0,1,255,1,255,0,254,0,0,1,254,254,255,1,0,0,1,255,255,0,0,1,0,1,1,0,1,255,1,254,254,1,255,2,1,1,0,255,255,0,255,255,1,1,254,0,1,2,0,0,0,0,0,1,1,254,0,255,0,0,0,255,1,0,255,0,0,1,1,0,1,255,0,255,1,255,1,254,1,255,254,0,254,255,1,255,255,1,255,2,0,1,254,0,255,1,1,255,2,255,254,255,0,255,0,1,255,255,2,2,0,255,255,1,1,255,255,1,255,0,255,0,255,254,0,254,0,2,254,0,2,255,255,2,0,255,255,0,255,255,0,0,0,0,0,0,255,0,0,1,255,0,255,1,255,1,0,255,255,1,2,254,1,0,1,1,2,0,0,2,0,2,1,0,1,255,1,0,0,0,2,0,1,255,255,0,255,255,255,0,1,255,1,1,2,1,254,1,2,0,254,254,255,1,0,255,0,1,1,255,0,254,0,1,0,0,1,2,1,0,255,255,2,255,0,1,0,0,1,255,0,255,255,0,255,255,1,1,0,1,0,255,255,254,255,1,255,255,254,254,1,255,0,254,0,0,0,1,0,1,254,1,0,0,255,1,0,2,1,254,0,0,1,0,1,1,0,1,0,0,2,0,0,2,1,254,255,0,2,2,1,0,0,1,255,0,0,1,2,255,0,255,2,0,1,254,2,0,255,1,1,2,255,0,255,254,2,255,255,0,0,0,1,2,0,1,255,255,255,255,0,0,2,255,1,1,0,2,2,0,255,0,255,0,254,0,0,255,0,0,255,1,254,1,1,2,0,255,2,254,1,0,0,0,2,2,1,1,1,0,1,1,1,255,254,0,0,1,255,255,255,1,254,255,254,255,255,255,2,1,255,0,0,1,1,0,255,255,0,1,0,255,1,0,255,0,255,2,1,255,255,0,1,255,1,1,0,0,0,0,2,0,2,1,1,2,0,0,254,1,1,255,255,1,0,0,0,1,255,1,255,0,255,2,255,1,0,255,255,0,0,255,1,0,0,0,0,255,0,0,1,255,0,0,1,255,0,254,254,1,1,255,0,0,255,255,254,0,0,255,1,0,255,255,1,254,1,1,255,254,255,0,255,255,0,1,2,0,255,0,255,0,0,1,0,1,0,255,1,0,255,254,1,1,255,0,1,1,0,2,1,0,0,0,1,254,2,255,0,0,2,255,254,2,255,255,1,1,1,1,0,0,1,255,2,0,0,0,1,1,255,0,254,0,255,0,254,1,0,0,0,254,254,254,255,0,0,1,2,0,254,255,255,1,255,0,2,255,255,0,255,0,0,1,255,0,255,1,0,0,1,255,0,0,255,0,1,0,0,0,0,254,254,1,255,0,1,255,255,255,0,1,255,1,255,1,1,1,0,1,1,0,255,255,1,255,1,0,0,0,0,255,0,0,0,255,1,0,255,255,255,255,1,1,0,1,1,0,255,255,255,0,2,255,0,0,1,255,0,1,2,1,254,1,255,255,255,255,255,254,0,255,0,0,0,1,1,1,0,255,1,1,0,255,0,255,0,1,255,0,0,0,254,1,1,2,2,1,0,2,0,0,255,254,255,0,0,255,0,0,255,255,2,0,0,1,1,0,0,2,1,1,2,254,255,1,0,0,0,0,1,255,255,2,2,0,254,1,1,2,1,1,254,1,254,255,2,255,255,1,254,255,1,0,1,0,0,254,2,254,255,1,255,0,0,255,0,1,0,255,1,1,1,255,1,2,0,0,254,0,0,255,255,255,0,1,255,1,255,0,2,1,0,0,0,255,254,255,254,255,0,254,2,0,1,255,0,0,0,255,255,254,2,1,1,254,0,2,1,255,255,255,0,254,0,0,255,1,1,2,0,0,0,0,255,255,1,255,1,255,255,0,2,254,0,255,0,0,0,254,1,1,0,255,255,1,255,2,0,1,0,254,254,255,0,1,1,0,255,0,1,2,255,2,1,255,1,1,0,1,0,255,1,255,1,255,1,0,255,0,1,255,1,1,0,0,255,0,255,2,2,0,0,1,0,1,0,1,1,255,0,0,254,255,0,0,255,254,0,0,2,1,0,255,255,0,1,0,2,1,0,2,0,0,255,0,1,0,255,255},
  {1,255,255,255,0,254,0,255,1,2,255,0,2,0,255,1,2,254,0,1,1,0,255,0,0,1,255,1,0,255,2,1,0,0,1,1,255,255,2,0,1,0,1,2,0,0,0,1,2,255,0,255,0,254,0,0,1,0,0,255,1,1,254,255,0,0,2,255,255,255,0,255,0,1,2,255,0,254,1,1,0,0,254,1,1,0,0,0,2,0,0,254,0,1,255,255,1,255,255,1,1,0,255,254,254,0,0,0,2,0,255,1,255,0,255,0,1,2,0,1,254,0,1,0,1,1,1,1,0,2,0,0,255,1,255,255,0,0,0,0,2,0,2,0,254,0,0,254,1,255,0,0,254,2,1,1,0,254,1,255,2,0,0,1,1,254,2,1,2,255,0,255,2,0,254,0,2,254,255,2,0,255,254,255,255,255,0,255,255,255,0,1,255,255,1,0,2,0,255,1,0,1,1,255,1,255,0,1,254,1,0,2,1,0,2,0,255,255,1,0,1,0,255,1,0,0,255,255,255,0,0,1,0,254,0,1,0,0,255,255,255,254,1,1,1,255,0,1,255,255,2,1,0,254,255,255,255,255,0,255,0,2,255,255,0,1,1,1,0,1,254,255,2,255,0,0,0,0,255,2,1,0,2,255,255,0,0,1,1,2,2,255,0,255,255,0,0,1,255,2,0,255,0,1,0,0,0,255,0,255,0,1,1,255,254,255,0,255,1,0,0,0,0,1,1,255,1,0,2,1,0,1,0,0,1,255,1,254,0,2,254,2,2,255,255,1,0,1,0,0,0,255,0,0,1,255,0,254,255,0,2,0,2,0,1,1,1,254,0,255,254,1,0,0,0,1,255,1,254,0,255,255,0,0,0,1,1,1,0,254,1,0,0,0,0,255,0,0,255,0,1,2,0,1,1,1,1,255,254,0,255,0,1,0,2,0,1,0,0,0,0,255,1,1,0,1,0,1,255,255,255,0,254,255,1,254,0,0,254,1,1,1,254,1,255,0,0,254,255,255,1,0,1,1,0,1,0,254,0,255,0,0,1,0,0,0,255,254,1,255,0,255,1,254,255,0,2,2,1,255,0,0,1,2,255,0,0,255,0,1,2,1,255,254,255,1,255,255,0,0,2,0,254,255,0,0,1,1,1,1,255,1,2,255,0,255,255,2,0,255,255,0,0,2,0,255,0,0,0,1,255,1,1,1,0,1,1,0,255,254,0,0,255,0,1,255,1,0,1,1,0,1,1,1,254,2,1,0,1,1,0,1,2,254,255,0,1,255,255,254,255,0,2,1,0,0,255,0,2,254,1,1,1,0,254,0,255,1,0,254,255,2,1,0,0,0,254,254,0,0,1,254,0,254,1,0,255,2,255,0,254,255,1,0,255,254,255,255,2,2,0,1,255,1,254,1,0,255,0,255,255,2,255,255,0,0,0,1,0,1,0,254,0,0,1,255,2,0,0,1,0,255,0,1,0,0,0,2,1,0,1,1,2,255,1,0,255,255,254,1,1,0,0,255,254,254,255,0,0,0,1,255,254,255,255,254,255,255,1,0,0,0,255,0,0,1,0,255,0,255,254,2,0,0,1,1,1,1,0,0,255,0,254,1,0,0,2,0,1,1,1,255,0,1,1,1,0,255,0,255,0,255,0,2,254,1,0,1,0,0,0,0,0,0,1,0,255,255,0,1,0,254,0,1,254,0,1,0,1,2,0,1,1,1,255,2,0,2,0,255,255,0,2,1,0,0,0,2,1,2,0,1,2,255,0,0,0,254,255,0,2,254,254,0,0,0,255,254,2,0,0,1,255,1,255,0,255,1,254,0,255,1,1,0,255,2,255,0,1,1,2,254,2,0,0,255,0,0,1,0,1,255,255,0,1,255,254,0,0,0,2,0,0,0,255,0,1,1,0,1,255,254,0,1,2,254,1,254,255,1,255,1,1,255,254,1,0,254,0,0,254,1,0,0,255,2,0,2,1,0,1,0,255,0,1,0,255,255,255,255,255,0,1,255,254,255,0,255,1,255,2,1,1,1,0,0,1,255,0,255,2,255,1,255,1,0,255,255,1,255,0,0,1,2,255,1,255,0,255,255,1,255,0,255,255,255,1,255,255,0,0,1,255,1,1,0,255,1,2,1,1,0,1,255,254,1,255,1,255,0,255,255,1,0,254,1,0,255,254,255,254,0,0,1,254,0,0,1,0,2,254,254,1,2,1,0,0,255,254,0,2,0,1,1,0,254,254,1,255,1,0,2,0,0,255,254,0,255,255,1,0,0,0,0,1,255,1,2,0,1,0,2,1,1,255,0,254,0,0,2,0,1,2,0,0,1,1,1,255,0,2,255,255,0,255,254,2,2,0,1,0,0,1,0,1,254,254,1,1,254,255,254,255,0,2,1,0,0,1,1,0,255,255,0,255,0,1,2,255,255,255,2,0,1,0,0,2,0,0,1,0,1,0,255,255,2,1,255,1,255,255,255,2,1,255,2,0,0,254,0,255,255,254,0,0,255,2,0,1,1,0,0,1,254,0,0,254,255,254,0,0,255,0,2,0,0,2,1,0,0,2,0,1,2,255,1,255,2,2,0,1,0,0,255,255,1,0,1,255,1,255,1,1,1,0,254,1,254,0,2,255,1,2,255,1,2,254,0,0,254,255,255,1,255,255,255,1,0,255,0,1,254,0,255,255,255,0,1,1,1,0,2,1,255,1,0,254,254,0,0,2,1,0,255,255,0,255,0,255,0,0,255,1,1,255,255,0,2,0,0,1,2,0,0,2,0,0,254,1,255,0,2,2,255,0,1,1,255,255,0,0,2,0,1,0,255,1,0,254,0,255,0,2,0,254,255,0,2,255,1,255,255,255,0,0,0,1},
  {255,0,254,255,0,1,0,1,1,0,0,0,2,254,1,0,1,1,0,254,0,254,0,255,1,0,0,1,1,1,254,0,255,255,0,254,0,2,255,2,1,0,1,0,1,1,1,255,2,0,0,0,0,2,0,2,254,0,0,2,255,1,255,0,0,254,255,1,254,1,1,255,1,1,1,254,255,255,1,255,255,0,0,2,2,255,0,1,254,2,2,0,1,0,255,0,0,1,1,255,2,0,0,0,0,1,2,255,255,1,0,2,255,1,0,2,2,1,0,255,0,2,255,255,0,1,0,255,0,0,0,2,2,254,0,0,0,1,1,0,1,255,1,0,0,1,255,1,0,0,255,2,255,255,0,0,255,2,0,1,1,2,255,1,255,255,0,254,255,2,0,1,255,1,0,1,0,0,254,0,1,0,1,254,1,255,255,255,255,0,255,1,255,255,254,255,1,0,0,2,0,255,255,1,0,255,255,0,0,1,2,254,1,0,255,1,254,0,1,255,0,255,0,0,0,255,0,2,254,1,255,255,0,255,1,255,255,255,255,255,0,0,1,0,0,2,0,1,255,2,0,0,255,0,255,1,255,0,0,0,0,1,2,0,254,255,0,0,1,255,0,255,1,0,254,255,255,2,1,0,0,0,255,0,1,0,1,0,0,1,254,254,255,255,254,1,255,0,0,2,0,0,1,254,0,0,0,1,254,254,2,255,1,0,0,0,0,1,1,1,255,0,0,255,255,1,0,254,2,0,0,2,255,255,255,1,255,255,255,255,2,1,1,255,0,254,0,1,2,255,1,0,2,255,255,1,2,254,1,255,0,255,1,0,0,1,1,1,255,0,0,2,0,0,1,0,0,0,254,0,255,1,255,1,0,255,255,0,255,254,0,255,254,1,2,0,255,255,0,0,255,0,255,255,0,255,255,0,254,255,0,254,2,0,1,1,2,0,255,255,1,1,254,1,0,1,255,255,0,0,0,0,255,255,255,1,255,0,0,0,2,0,255,1,1,0,255,254,0,0,255,1,0,0,255,254,0,0,0,1,0,0,254,2,255,0,255,255,1,1,0,0,0,255,0,1,1,255,1,255,1,0,255,2,1,0,255,1,2,1,255,2,1,255,255,254,0,1,0,0,1,0,2,2,0,0,255,1,1,255,0,0,0,1,1,254,255,0,0,2,1,255,2,1,2,0,254,254,255,1,0,255,0,255,1,255,0,0,2,2,2,255,0,0,0,0,0,254,1,1,1,255,0,2,255,1,0,0,255,2,255,0,255,0,0,1,1,1,0,1,255,0,255,1,0,1,0,255,255,0,255,2,1,1,0,2,255,1,0,0,0,2,254,1,255,255,255,255,0,0,255,1,0,255,0,0,0,255,0,255,0,2,0,1,1,0,1,255,255,255,254,1,0,1,0,0,0,0,0,1,1,2,254,255,0,0,255,255,255,1,255,2,1,0,254,1,255,254,0,0,255,255,255,0,1,0,255,0,255,254,254,0,1,1,254,0,255,254,1,0,1,255,1,0,0,254,0,255,254,255,1,255,0,2,1,255,2,254,254,2,0,1,0,255,255,0,1,255,0,255,1,1,0,254,1,0,0,254,0,1,2,254,0,1,1,0,0,0,0,254,0,1,1,0,1,2,254,255,254,255,255,0,0,255,255,255,255,1,255,0,0,0,255,0,0,255,0,255,254,255,255,0,0,255,0,0,1,0,1,255,255,0,2,255,0,255,0,255,0,1,1,254,0,0,0,0,0,1,255,0,0,255,255,0,0,1,1,255,0,0,255,255,0,0,1,0,0,255,255,0,1,2,0,1,255,1,255,1,255,255,255,255,255,1,1,0,255,255,0,0,2,2,0,0,1,0,255,254,1,1,1,1,0,255,1,0,1,2,0,1,0,0,0,0,1,255,255,0,0,0,254,1,1,0,1,2,0,1,255,1,1,0,255,1,0,0,2,1,2,2,2,2,255,0,1,255,0,1,0,255,0,255,0,1,1,1,1,255,1,254,0,1,0,0,1,0,0,1,1,254,254,0,1,0,254,254,1,1,0,0,255,1,0,1,255,0,0,1,254,1,255,0,255,0,0,1,0,0,255,255,0,1,0,1,0,2,255,255,1,0,0,0,0,254,2,0,0,2,0,255,1,255,254,0,255,255,254,0,255,0,0,255,255,0,1,0,0,1,255,1,1,255,1,0,255,0,1,0,0,1,0,0,0,2,255,0,2,1,255,1,1,1,1,254,2,2,0,0,1,0,255,254,255,1,255,255,254,2,1,0,0,0,1,1,1,0,0,255,255,255,255,255,0,0,254,255,1,0,2,0,255,0,255,254,254,1,1,254,255,255,0,1,1,0,1,2,2,0,254,1,0,2,0,0,0,255,255,255,1,1,0,0,0,0,1,255,0,0,0,255,254,1,2,255,254,1,1,254,0,0,1,254,1,0,0,255,0,0,255,255,0,255,2,0,0,1,1,0,254,255,2,2,2,254,0,2,0,1,255,255,0,2,0,255,255,254,0,1,254,255,255,0,1,255,0,1,254,1,255,254,2,255,0,254,1,2,1,254,254,255,255,255,0,0,1,0,1,0,0,255,0,0,255,0,255,2,1,255,0,0,1,0,0,255,0,255,1,255,254,2,255,0,0,255,1,0,255,255,255,0,0,1,254,255,1,2,1,255,255,2,254,1,1,2,0,255,0,255,255,255,255,1,0,255,0,0,0,1,2,1,255,255,1,255,255,0,255,0,255,1,255,255,1,1,255,254,0,255,255,254,254,0,1,255,1,1,254,0,0,0,1,255,1,1,255,0,1,0,255,254,1,255,0,0,0,0,0,1,254,254,1,254,0,1,1,0,1,2,0,0,1,255,1,255,0,255,255},
} ;

static const int16_t precomputed_encode_1277xfreeze3_x[precomputed_encode_1277xfreeze3_NUM][crypto_encode_ITEMS] = {
  {30935,19029,-24504,23706,-1053,1251,-12052,-26539,-9316,-24889,-15955,20276,-6156,18755,-4337,846,-15175,520,9677,4911,-7656,-29849,27987,2911,-1123,19680,-11995,-7497,23964,-13383,14312,18985,3811,5814,-24681,-32043,-9315,-13263,5476,21513,25139,-22080,17065,-30172,-29401,4852,-21814,15518,-21349,31472,-28364,20026,20039,-8391,-18873,1069,-8016,6236,22961,-15918,-12172,-19290,-27679,16021,-11786,-3988,-31830,18667,-28683,-1285,20171,5352,-8676,19805,-3460,4257,-5545,13101,25463,-25727,-17579,24578,26122,-29262,22569,32551,9826,816,11042,-30062,-3729,-5213,5401,-23066,30427,3443,-19509,20210,-13231,24392,-30409,-22098,18465,-13491,32218,-31503,-15956,4057,19361,-5564,-5653,30466,10491,-23922,15828,-28135,-24964,31465,8806,-821,-8044,-15052,899,-14582,27242,14564,1780,-7839,1242,24306,21603,15543,31354,18808,24282,8511,-29136,-19422,1500,28950,-32222,10493,27340,9219,32126,-18407,-16892,13055,28863,23983,-422,-2021,-13854,26096,-5038,-32427,29263,5256,-11357,32524,-20677,2066,-25978,-32195,27906,4807,-24986,745,13443,220,5125,-1945,-28050,17772,-3715,-25672,-13322,25006,-22296,26690,-11060,-20424,9205,11024,-11480,788,7959,1378,1113,19908,20672,-6416,-13684,9102,3646,12208,-32113,32485,-28304,18329,-22606,-28162,-1933,-8507,10698,27458,12815,-19480,-11180,26196,26285,-2350,-15011,23951,5086,26859,-19108,-27961,-21828,-15758,-20902,-7776,-21833,30883,-26734,11201,-19006,27193,16817,10097,-2655,-20120,-7405,31596,14306,-7158,17119,-10127,-3709,-26047,-31451,31965,-472,26534,28057,-5912,15959,-32439,-7702,2280,-13082,29222,-7798,11258,-9324,-5695,-26780,-22789,-2149,2564,2346,-6179,-21343,-31620,-6757,14935,7321,-29200,25640,-31648,15810,-20642,-23024,-24811,32724,22658,8787,23337,23777,20651,18467,-17573,-17002,-13146,-30162,15303,-28154,15216,-3784,-13437,-8347,-17810,-13105,16968,8872,-8095,-19748,-19210,4620,-15227,-26885,7237,9829,24202,22712,-5012,-11961,-16673,15087,28458,4695,19767,11263,-1756,14351,16250,20372,26747,-7240,25232,-9546,30490,14341,9424,6379,107,-17379,24981,-32494,11449,28038,17392,1068,6441,-19797,-10608,-25028,-24882,-32110,26300,-1219,-1012,-21065,-7296,-22728,-26452,15062,-16192,20944,14733,-24111,-6913,29240,4152,11879,-31510,29590,27448,-27643,-23076,16665,32706,32680,-26101,-19991,-32055,-13279,19999,30536,27475,-13363,-27149,6085,19027,15879,-27901,-31330,-18400,24148,-15162,2737,-19648,17661,-23078,13713,-15001,-2449,14579,8191,-25186,-14946,-10870,-24323,25666,-9315,6309,-16173,10880,-14444,23484,-10202,8012,-18481,20276,-27990,29622,-25940,-27999,-4968,-27345,20109,-14229,19493,-23257,27640,3304,13252,14551,9505,7304,-31850,-15805,20921,-27722,-8617,32166,30879,-10088,-12050,3208,-21270,-30106,-4683,23072,-5683,-2805,11052,-15805,-26866,-25333,-2854,27744,8594,-26576,-29599,1934,18271,-27857,-29139,2527,24961,-16730,-18969,24343,-20979,23910,28873,23179,-10495,10914,-18601,26688,-27518,6981,-9911,-21892,28898,-14489,-25680,-26554,-19549,-21333,-5130,7735,-26959,13833,20479,14911,-1003,19989,-21552,19593,-1120,-2888,8853,19744,26063,-12998,-3761,14199,9609,-1941,-953,27492,-21042,-19712,-29215,-6603,-22894,-15089,-12413,24907,31678,-26471,-23891,12681,22819,11877,16776,5400,21261,11582,-3655,-3631,10404,6619,-15252,4242,26167,-28356,-27852,-10110,-17750,-8932,-6029,-26264,-18175,24752,-28903,32190,-17992,-32156,-19702,24697,17483,-31833,30087,-967,29557,24563,5238,16227,27288,-25647,21786,16891,-23965,-23168,-5460,-21344,16447,-19694,21187,11984,-26251,-19432,-30914,-16211,-13003,1334,18390,31517,8421,-23932,-3862,-4971,19200,32738,-17779,29837,-20431,7202,20547,-16390,22240,-17987,-12994,20548,11124,-30144,3551,-17701,-7431,-3586,-23240,-9024,-4820,19303,16576,11279,108,10063,19770,1401,25185,-18470,28694,-8779,-21224,13443,3132,-26833,29531,25834,24984,25873,24025,-31279,3855,-19305,23284,-5846,-15980,5749,-30175,-17627,-13,25309,-2033,10188,2258,-824,28055,15571,-6252,-20803,4146,18708,-9975,-12475,-14583,-12877,-5110,-3773,-2357,-1372,519,-17304,11199,-2208,30745,19890,20899,19845,16937,-23849,26749,11689,-9709,14558,-5147,24292,31141,30423,1696,-232,18860,31695,3000,27047,23210,25337,-27269,15930,-13070,15760,22678,9867,-1118,-28691,28749,8756,-12532,27970,-28469,16899,-1472,19299,-9150,-27684,18302,9429,-27497,-4397,31029,4986,6220,26156,-2995,24901,-29650,355,-22867,-18044,-13779,12671,-1587,15673,9808,-4177,16298,24403,23221,6790,25237,-4708,13080,22026,-7851,-548,177,18568,6054,-30909,-4265,3245,27309,-24328,-997,-6714,6609,-21817,-24726,-20780,16965,-9373,-5793,3157,-9684,12806,-16264,-8169,7390,-4850,31235,-20510,-6794,10715,-20077,-7830,-21174,-5198,-17933,28688,-1326,-9394,-21598,28649,-31289,-22058,9135,15159,23769,-32475,20931,-15596,3263,-27861,-12170,-755,-18709,-26286,-16585,-718,3390,-10732,5361,-30700,-29744,20890,29403,-9626,-20737,25646,6952,-23310,-6286,-10191,-14310,3048,-3188,21398,-2172,11892,-18097,-8025,-3857,-16499,-10686,-17544,11735,-28758,17650,-19880,-7360,-19852,2898,-3428,-18637,25126,19137,6827,-25528,-3341,21723,4380,-9369,-13049,15446,-4533,-26835,-7688,-10978,-2513,-18878,9267,-12910,16643,2527,-3046,-31385,-11299,12362,5885,-14176,-17193,3815,10929,-14088,17158,-7533,-2187,1729,21400,-24063,9891,-23035,-14457,4843,-11303,-14410,1437,32274,-20809,-4149,-2713,-15996,27951,25504,12895,30710,-9830,-25004,1855,26596,-17972,11101,4099,14321,-9079,4379,468,14898,-18511,-13253,-23097,32076,21709,18600,13376,31431,-26167,11741,-12177,14377,-3764,-12045,5469,-13396,4479,9568,-16613,8497,-18489,19133,-6557,-20777,17851,-6982,28616,30062,-12094,18228,-6326,2916,13514,-3021,2761,-5604,-9712,30273,916,-23260,9254,-3251,25759,-7163,-10047,-27115,-5541,-32603,31040,-5287,-28832,-26711,9654,29798,8667,19306,30304,4238,22386,741,-27142,18209,18474,1807,15416,11547,24359,-1289,32145,11226,-28160,-19103,31572,-46,-10757,-31946,5993,-15010,-4688,-24452,-20944,31759,-22686,28544,18286,-20628,-19195,-24471,-18081,23416,5960,-17001,-3160,11355,-9773,3585,-18922,31642,-8001,-1642,-27138,-5012,-3672,29591,-18198,-32165,-6834,-12132,-31902,22591,-26746,-17798,-19317,24757,1675,-26300,11375,17390,17372,-1528,-8295,9983,10083,-7751,22316,12183,23395,-20142,-32277,-16688,-2566,31973,-13885,-7944,-24301,-14077,-12382,26131,23531,10633,32381,-28828,-4315,-32276,-2063,14378,12668,-931,-230,-24089,-16570,-1128,17111,-27771,-14086,12590,16060,29902,-17958,25709,32091,-24877,-21918,-6862,8083,-1472,19938,8426,-21135,4703,25101,-27550,12355,17230,-9969,8430,-4781,-24307,-21652,25399,-9497,23377,19061,21786,-609,17887,13740,-24366,-6556,-20883,23173,6726,-9111,-21101,24123,8182,-2158,3168,22980,-10833,-11411,959,-16757,18603,-26449,17533,28812,-27755,-14406,-4885,-12519,-32394,-21642,19525,1791,-26797,20133,-30028,30504,-5040,-16350,915,-28018,17898,-16933,11476,19746,-10568,-4193,-7915,29109,5031,-5750,-4632,-5090,-16493,3585,-10826,30097,212,10300,10192,-6373,-27993,-16244,-8046,-28693,25817,698,1091,-9206,-14607,-20209,-12297,-15345,13903,24786,7383,-8384,30373,2939,2236,-30134,-22989,32521,28532,21464,-4180,-24062,6708,913,-17765,-10927,-10987,1949,-14958,15488,3333,-10640,-2995,14056,14245,-3916,5739,-28683,20128,-3230,12229,-24276,25318,-4639,13724,23034,29739,-30076,-21148,32689,-29853,588,-9279,26004,21098,-21658,-1749,-28311,32023,12017,-30929,13363,7504,1214,72,-2900,-31994,3068,-9003,-891,14000,-5434,11879,-9048,-15950,30718,-5380,17878,9176,22825,10674,10202,-3863,11340,1585,-4354,7641,19006,10321,12675,-29417,-11823,3627,4166,-19080,-12472,27089,22733,25668,-10274,-22633,17564,-32691,4279,-6371,30233,6035,1422,11870,-28208,17136,-17434,27633,1033,4095,3968,15752,-14465,9281,-19740,-2218,-20427,25814,28231,22536,9300,-17827,11826,-4943,-13257,-32715,-26380,-17154,20477,29078,-12290,-13686,-26525,-15563,25349,29682,18194,-5062,15485,12795,-25523,14900,-5810,6969,-25781,32746,-16906,7466,14914,24752,28129,-14103,10083,-28736,4260,19955,18160,-32724,18667,-26632,-12001,27041},
  {-14696,-27699,28693,-25173,15760,-30649,-29749,-2068,-31897,-26410,-31900,20459,23345,-7123,-7562,10209,-1947,-29576,-16269,-32329,-6658,-12572,-29308,29384,-29744,-24258,24259,-6472,18432,-32291,3500,13312,-21586,-14224,-26572,16659,27116,-18596,-3447,-16386,-2455,-31098,30373,18007,16940,10587,17373,-12741,-29076,3680,-32082,15880,-513,10825,-30377,8823,-815,-14547,2355,-31370,-8443,29680,-9512,-10226,19009,-18722,-24036,29214,-4215,637,19654,15710,21189,1316,-12024,-20227,-16415,-369,-18052,5272,-26839,17564,-26355,22935,-27840,-11734,6613,-31191,-18450,-27420,-26824,-19788,12876,25237,7301,-32706,-30201,-19508,-29731,-31198,14698,-20273,-29484,13596,9300,23766,7027,-28748,-32129,14989,27965,2882,1077,24587,6919,2243,-32383,-11213,-19479,-12161,-2305,1438,-5811,1255,11332,-17591,-23699,14657,4299,-16052,14028,17215,-18053,-30034,3263,1035,-31285,-1313,-14058,3156,-29552,-12413,-6235,-1607,31508,-28748,6547,10478,7669,14741,-23789,-4697,-1278,-5888,-11390,22063,23963,-21869,-2551,-3468,-32763,-20372,-13559,-32627,-28682,841,-16034,7589,21830,-10711,-2043,18045,7284,2898,24838,-12756,23587,-30533,4438,17579,18868,-30690,25484,-7995,-27718,4010,2574,2318,22213,-17136,9304,15943,-10099,-5760,-12151,-20074,19077,-28370,13352,28297,17405,29801,4014,-27728,-13991,-21399,14609,-8796,1647,-8054,31549,18447,18382,-28482,-17244,20047,-26594,7101,-6311,-21503,-5061,5128,18343,-28236,-3266,-8399,32542,25150,18703,-17551,-14421,25196,-5241,9109,5341,-9742,13829,4197,-24649,10325,-4649,19038,-15234,-15666,5139,32736,10022,8418,14909,2902,-26610,29008,-290,9722,23601,32660,19176,-11820,27195,-22670,27291,-9529,-3423,557,-19079,-12943,17774,-24288,-9535,-11898,10223,-10257,25367,-21308,-11344,-27165,-18632,28529,-3816,-30422,29805,-8738,9950,-8168,11598,-25765,14893,-22605,14676,16381,5445,-12084,18890,-26258,18408,29506,7840,-26073,-705,-10212,-19751,-5850,6922,19632,21613,-11104,24998,-13737,-25585,12442,-4533,29969,-25145,-22518,-25469,2106,508,-16489,-28968,-2605,18690,25300,-1103,-12119,-4612,27245,21725,-16593,29206,-25675,-24649,-29949,-30232,-8607,-2683,-9001,5193,23268,-12923,15782,-22718,-5716,-26496,25654,-26475,-25926,-21983,24835,29521,-4360,-21083,22863,-30675,-10244,16658,16274,-26304,-28488,-3263,-14190,4459,-13004,19314,-32210,-14056,-5612,17938,31273,-30092,9362,-16549,9244,-18647,16473,16985,26714,22866,3737,-8587,-1475,7051,28726,-13713,-23195,-16591,906,18558,783,31446,-23883,-32378,4828,28366,-3660,17378,-13398,-8001,-15561,12755,10816,13989,-13564,21651,13443,-11378,-23399,5217,-19547,23096,-10248,17381,-11915,10580,-27104,22141,-5405,-12361,17392,27762,18637,-9874,-10523,21146,-12745,-22478,5402,-24838,-14850,13108,17365,2166,-13918,-17411,-500,-2956,-20353,-10927,21895,21512,-26793,5186,-8850,-30287,-5494,28490,-19615,-24451,-378,31055,-12358,-5558,577,12032,20456,-6740,30770,28755,25322,-25500,14189,23482,-19635,18967,-12222,-18289,17725,25674,-21979,-6742,-10924,-23401,-1116,6923,6206,26607,5921,10946,-10671,22473,-11853,-1983,-25287,15366,-4114,22542,-1584,-20099,12638,26535,17642,-11081,13793,-30623,23748,971,1718,1390,-20050,22114,-25799,-28659,13237,-6560,-26572,-12762,-12942,-17683,22101,-31285,9160,30273,11320,21134,4618,-13725,-20625,-14556,-21349,11706,-28274,23426,23246,-6105,25814,-5428,20066,-14874,-30701,-5068,-18683,7693,-17614,-13445,29203,-8189,-30991,-9780,18658,19327,28163,-5105,-31365,22433,-32727,-16991,-18641,-16372,-32682,16612,-19074,-1349,25869,16368,-17642,-23563,-22307,-29799,25118,-3937,-25099,11867,-6639,4462,21516,-12807,-23288,-5290,-17955,16577,-7504,31746,-14935,27101,8347,-7742,-20364,-16373,-3552,2372,21371,24508,-8620,-2234,-4324,-11731,17350,25912,-10499,3344,-1998,23179,-10449,-10011,30501,-24497,32400,15604,22303,-2330,11052,27999,21191,-2267,-5664,-31426,-18551,27205,4437,23064,1489,32241,16381,12637,3936,-16451,-23076,20337,-19414,14427,-20706,-31402,4339,24538,1322,3441,-28522,-21787,11050,-31791,-13941,-21725,9809,-5940,26070,-9374,-24430,21620,-14394,22760,-25792,23202,3532,31891,-19849,17766,31508,-16982,-2783,-19798,19907,-30108,10823,22360,-31141,23960,11453,17394,-852,21228,10642,-20743,13203,15106,-1873,31877,-12769,-1948,31494,-21588,-24712,31670,3394,-9284,-13017,-23188,-29329,-5166,21884,27711,-12901,12036,29089,-3489,-25395,-3625,-25716,-17970,9473,-26195,28282,-20693,-29003,-26494,22992,17870,-20986,31063,-25295,27915,5025,14499,-26248,-21040,-16838,1111,15676,4506,8779,13312,-30653,-61,24037,-26331,-27960,-11759,30920,-12103,23981,-29843,27829,-8338,29521,12032,32042,15914,-18181,-9173,11750,5589,-28917,-2519,-12248,-1428,23204,13106,-26856,4714,11499,10544,13741,20517,-11995,9426,-11728,-31375,-740,19292,-15457,8439,-16418,-14482,-215,14146,-15834,-20355,-27186,-3867,-21037,5190,-22642,2194,9256,-19384,-5691,-26997,31018,9640,-1766,29516,-7183,-4280,-1644,1686,7440,-191,1892,-29915,9794,-32361,31757,-26752,-9964,97,780,15329,-6403,24840,29079,-1306,11995,15468,-22527,-18183,-3543,23864,25263,-30192,-21917,-6997,28227,23571,1000,7229,-4581,29452,25840,-20801,-7025,15932,28533,21489,-11200,-12805,18589,5667,-21261,24920,10129,30969,18074,2903,-7553,19045,1459,-25553,12809,28966,28466,-11100,-1036,-5095,-11211,2557,-23053,14415,-6868,972,-451,-32397,-23436,-25256,-909,4177,-13905,1763,874,-9708,-12316,32572,-12278,-32624,2282,13803,-7664,10852,-24357,-19627,-1526,-15090,-16269,25137,9883,19009,-20476,10595,-31500,12609,-23989,3449,23209,-23554,14219,28001,15241,13246,-15971,-12758,2151,-14886,7615,30281,-29977,11889,9999,-29931,-10094,-18827,-4486,-14676,20008,11367,17537,26886,21001,-16463,-31284,-16620,15108,27409,23581,20209,-12004,-20106,10380,-13775,-23782,13011,21211,26900,1031,-3176,-12928,14562,-23044,22184,21854,17079,31556,-876,17922,-5405,-5155,29280,-10582,16228,-5127,21513,-5957,9851,10656,15468,23021,31032,-21887,-7578,-2688,16902,1794,27487,19258,-30494,25385,12528,8887,25439,-6781,20150,10872,3025,6272,-14351,7646,-27755,-22538,-18671,23034,13816,4534,24291,-1558,31640,7996,18068,-9194,-29748,-14889,-24261,-30594,-3310,-7245,-18258,32496,20375,-27068,32112,-16069,-9523,26903,-7129,-13418,3094,-15096,2455,-22772,28527,5108,14162,-15346,5676,-17149,30635,-13350,-11895,-15182,23513,441,-25547,-21685,6823,21925,-18455,-13474,23027,26087,12074,25412,16792,-31500,-16072,-32280,9714,-17874,5311,-2951,-25700,30741,-9841,-29573,-28988,-27141,-6820,8205,-6712,-9129,-290,-16249,-29754,-23649,26583,27469,-24782,-6350,-31486,-30442,-22364,-29829,-19066,-3,-1362,17117,17800,30266,28854,25020,27575,-13032,29805,932,10745,-32716,-21207,17535,-19253,-26552,19092,-25137,-22195,-18194,-30908,-20464,29872,12581,-13241,3420,-27585,31668,-25236,-1061,-2977,-7651,-17176,-22576,25326,32053,-24044,-6317,-24394,-15866,5893,23872,1552,22372,-14194,-18823,-8029,29870,4105,27571,10409,-16097,-22620,-15251,31263,-10152,23107,-28783,28759,19358,1384,-9313,-7617,16650,24590,7311,5215,8316,263,12460,13144,-24032,29606,-19598,-17527,5670,28314,17248,14382,-60,1904,5354,-4639,-22332,-13244,-14326,-31439,-10186,12018,-18031,8689,-26100,-8166,5394,6176,21550,-1972,25915,10664,12858,24241,-21265,-28707,-6410,-109,12039,-8817,-25083,-13954,-1120,30106,-25552,-10385,-4775,24148,-3024,-30307,-30737,7853,21041,26063,-30660,26710,-8409,2118,-460,-12773,-12494,-29170,18783,-15450,27237,-19833,-742,-14110,6433,3968,-4511,9365,16322,-12174,-32314,29848,3795,15056,183,26940,24186,27736,2611,-15503,-23043,-10051,19601,-9884,1493,-19966,-4722,14440,-29802,17098,16444,18068,18642,-13943,7771,-12900,6056,-24864,-31979,-25972,26345,-25384,14755,11852,-17363,-29810,-11439,-31592,27885,8804,-8891,12080,-19760,32270,9259,5082,27416,9555,9457,-2578,-989,-19595,13347,16902,27824,9243,24281,-20953,-16861,-2652,-9510,-13547,26589,-24005,-7767,-18680,-15194,3974,-10563,20901,17365,24128,31806,28044,18944,17302,1467,29436,-25933,-2711,-17049,-7405,13475,6042,-32375,-23640,-20128,5629,-1248,-20392,26382,-1398,-202,-17790,2212,18732,23792,30884},
  {-24539,29597,-7534,-2887,-24537,22804,-31347,-3373,-14666,-24439,4187,-10803,-18997,-24543,-5080,1192,-32287,30226,18159,4618,244,21213,11978,16689,22731,15811,30866,-2981,5811,-3430,-23032,-20759,-6942,-26889,-23396,-1490,12674,-10810,-17137,-15918,-25682,17097,8161,-29584,1647,18204,11184,8713,-20890,-8908,-11088,29213,24393,28783,-21444,-31179,-25133,-2631,23979,-8626,-1265,8752,28585,-931,-19749,-22302,-27253,12281,4457,-3070,23580,-12406,13977,-8900,-16435,-4084,11922,21502,4594,-6194,19101,-16086,23251,-716,-22688,-24741,22827,11067,-25996,-17670,17847,26041,-30321,15364,-994,-1309,-2216,5855,22007,2878,-6137,-4971,-9592,25768,31510,4446,32709,-23985,-18805,-26319,2939,-29888,21110,15645,-2899,23826,-31169,-21235,-11742,-17510,27550,7356,12859,-19779,-28184,-20738,-14351,-419,20418,-27847,32286,17550,-4405,10702,7517,21551,-20061,17883,-29007,9327,-22297,-25632,-17317,-5985,29167,9309,-10167,28402,-7724,5030,24534,-29046,23377,-23911,-32312,-25448,29280,19123,-3455,-15487,-24292,-567,8325,-4787,12598,16768,-17173,-9971,-22210,4622,12438,13823,-26269,-15501,22381,-23628,-21946,31969,1286,-17938,15036,-7507,23989,1454,-13708,3581,6564,25298,-5107,-13282,-18654,-1040,-3865,7439,-2513,-11184,-22627,30333,5384,-12560,25791,-16826,-14531,21368,15370,15305,16500,-2480,30907,10015,-13854,-27760,-17681,-5160,-18439,29670,-745,16133,-3650,-28551,-23324,30360,-3106,-20891,-17184,-9330,12305,-14935,-13165,30054,17709,-11816,-32151,32620,-30132,-22289,-20232,31593,30266,-3097,24137,19846,-19463,-20588,11368,13004,28236,11659,27365,26750,-18466,-32636,-19689,22000,23513,21275,-9754,16166,19728,-5275,11373,-27469,7403,-3148,15537,-1193,-27557,-12920,-8529,-24077,25666,-7084,-17026,5888,-23097,-12687,-26961,-31017,1568,-27730,3151,-6753,-20536,-9655,28853,25275,-29025,-4067,-24770,-26566,-20344,28673,31977,-502,-14047,31641,-24450,-26537,25688,-28000,3357,-8467,32247,-23159,-4731,-19137,27906,-1663,9267,-5791,25020,-10982,-10364,24404,17548,-7312,-22632,9125,-23696,-32358,-27018,30417,30573,-20582,-21986,15947,9220,-18747,-19333,9190,-30714,1453,7083,22320,-25706,-11782,-1211,21967,31983,-24313,22945,-21733,-32290,-12532,7772,7600,13416,-12314,-5184,-5445,24168,-8257,-3777,15018,9409,-7075,3924,23380,31184,16701,-25315,7965,-19795,8001,-9317,1585,7,21850,2337,32741,28612,-21347,4983,7854,-16860,-28472,19907,10798,26983,25554,2705,12827,5466,-19536,-11082,-4544,-13403,-18965,963,22294,7036,-24339,17394,-18630,-13164,12830,19608,-9420,-15502,-23478,-21380,-24814,10158,-25136,-19010,7420,-4745,20984,29923,3495,-4210,31236,12307,19188,-17977,-27984,-8222,25566,24135,7287,28494,-13414,607,-19925,-22101,-24716,-8313,-21485,-13618,-10456,-7060,-26850,21574,26321,14950,22912,17649,2622,17395,-4685,-5405,7951,20464,15742,512,23886,-28359,28099,-10342,-6973,-10109,-24792,7906,-26444,31068,-31034,13077,27646,3246,3230,-32445,24006,8830,-21747,3324,21984,-11542,20359,-23480,-9175,17868,-3808,11032,19939,1256,-8979,-31981,-23890,-22157,21074,16140,-7446,-8426,-23695,455,11268,32556,28118,12528,13207,-25009,-6803,16319,26269,4994,-4973,2552,-10435,31362,-4377,-16891,17919,16405,19817,4539,-27225,-20351,-380,-22790,649,13151,-13325,-32317,-14155,19611,-13681,1535,-19069,-17601,23240,-895,3372,6285,-23707,13791,-13951,-3090,-5040,-30324,-13082,12518,-26678,11206,-16679,26769,12055,-13565,26856,-2389,17896,3015,-26871,12299,29103,-25913,26105,-24578,27132,-31109,-26222,9066,-11354,7462,-14864,24046,-28618,-7793,-5982,-31811,-32312,12822,4975,-20686,23332,4100,27483,-11816,8606,1697,25126,-12022,13110,-23257,-9029,12192,6771,27770,-8121,-19303,30376,-19916,-1364,-14498,9108,31546,11613,-13324,-3566,15951,21337,11801,-29797,-28859,-20856,4329,-13299,26401,27361,-8613,-4890,-6263,26662,28395,25258,-17279,14550,10127,-27925,794,28872,21061,-14986,-27542,-5298,-7627,17029,20276,5804,-27370,-25279,-20817,12556,14501,-25694,19798,9085,-19113,9872,26445,-5584,4568,-24355,25520,29567,14481,-14280,-30003,4315,3801,-10871,-26343,22309,27240,25479,-24053,-3511,-19597,26769,31002,7636,11934,-15991,16095,-1187,-2697,27918,-8013,-22687,-22379,32121,2713,-25937,-19600,5660,-26153,-7368,-10483,25625,30649,-22355,-31073,891,20472,21833,20617,25819,31559,13167,-11499,14883,-14381,24803,17263,21164,10997,32167,20906,5180,3484,29553,-29799,3210,-8014,7797,22749,-15815,31962,8552,23901,27821,30286,-22018,-28857,-16194,253,6859,-10019,-17096,-3600,15984,1661,19104,19627,-9920,28773,-15840,-29257,8769,844,-17195,3400,6119,19071,-9671,-19469,8212,21990,13814,-27339,2687,29814,27824,24621,-32239,16798,-15515,-6630,-12551,-11502,-32706,-18186,14688,2967,-31650,-27941,-13278,-1057,26333,-28389,4210,-30435,29896,19461,-8753,28651,-25062,-1208,30363,15256,-24334,-20436,-26294,-20129,-16124,29147,-32179,14661,-16729,-12555,-10540,-5629,-16077,-25477,-5363,-23682,-13524,-15606,-21313,-578,-17338,-8946,14428,-22963,-6598,25170,23331,23250,17437,-11620,7101,-24205,27955,25315,-12171,-10836,15831,4913,25135,-21778,14805,-26427,-12986,2054,6937,19196,12555,21035,-28094,20881,3312,-8923,-10481,-19124,-24144,8933,-20878,-9988,29121,-10424,14587,-18616,25315,-29419,16827,28101,-1792,24687,-29973,-6992,-129,-17708,2705,8537,-6573,-30716,-6097,17167,-17529,-885,-22755,-18937,-14268,7503,-18147,-8128,2883,1168,-16466,9369,-32396,3350,26722,-28188,3511,-16402,27676,10219,22009,31100,-23210,-11989,-14141,-20549,-13612,19831,3286,-23079,22465,-14424,5598,22681,-30812,-11703,-10848,-9733,-22276,-14589,-31477,-18848,-17721,4915,-23190,20918,-24606,-22550,21744,25040,16142,-14527,15671,-4132,-2868,6826,26465,25018,22232,-2127,24860,1204,12002,-19483,-6167,-26057,-4793,-14121,-25122,-10046,9092,28461,-9019,-19690,29207,-962,5027,652,-31044,-5683,206,-16493,-14623,-5568,6465,-4199,-16642,4697,-12110,-12625,-9066,3968,9089,-5936,-16144,11907,12206,-3772,-175,13606,9113,2372,25323,2052,-7787,-4546,-2903,-7022,24,11840,-30425,-23980,-24155,4561,28455,-23747,31862,19762,-14867,23513,3259,-3418,-30732,18029,1277,-17897,23577,17161,-6629,31428,-5893,29482,15539,20191,9495,14427,1708,18397,29679,-18171,13360,2013,-28858,30016,32029,-785,-21376,-28205,-19797,12204,-220,19723,24813,-27718,32619,-25433,4204,17685,30766,22000,-11096,13298,-8453,-17319,-20620,-7404,13092,6503,27922,-16344,29984,-7204,2758,-27366,18657,7059,-23241,10549,32171,-9083,-28759,-13671,-15200,18252,-29425,10594,14074,-12493,-32208,20446,-25569,-22446,-17860,16653,-11123,-31732,-5088,19959,-6908,-26453,-14354,1868,17952,-31384,28217,7634,-24390,18185,32320,-24103,-27307,7608,-320,6306,-15990,9193,-27132,4378,20308,17905,-31379,-22844,22027,-14968,30472,5744,9078,-29167,-28193,8139,9639,892,-16820,-30342,18200,-13855,-3768,15416,10239,-14420,-18328,15620,6473,7148,-20359,-16425,9520,-29292,-8904,-17590,21411,-162,-20279,4623,-15335,1092,6815,-11524,-17704,-30809,-16372,-1217,19940,-10492,16094,-25135,11926,1547,-28720,5538,24102,25990,10992,19934,30341,22414,-25053,-28386,713,-16900,2274,-428,-27260,8040,1212,2866,23206,-6021,27846,31801,1136,24961,20022,-4941,8819,5070,-20497,-4503,-30123,-16750,10534,24108,-25968,-32257,-4503,6883,-27253,125,-18428,19529,-30415,-19516,-8931,-16766,-16929,-15483,22262,6695,-20813,-32400,-25613,14303,-3920,15050,-12854,-29606,-21662,-3222,20131,-22391,31213,-27507,-23506,14078,-10787,-26857,-14443,-14699,-24610,22501,-18630,24882,18550,26234,-12973,2449,-12139,25586,-7357,-10967,27699,3575,-6735,-14957,21187,19887,8363,9812,-7363,-20862,10762,-12572,-18875,22650,-23569,1180,-15781,331,20187,32095,20053,25602,-27975,-28000,-14828,-17217,-5257,8621,29070,27398,-21732,32090,-22647,-6117,18548,-12593,5458,-1864,28154,-28290,-32734,31314,-6369,-24587,-18847,-5463,-12948,-27547,26709,31260,18847,2329,-15538,30165,-30184,-16939,11591,-10467,-15935,1351,-15328,13082,-32094,20589,-32158,32400,4633,-31677,-5950,10369,-1104,17665,26439,20984,5706,-32155,30795,16996,31148,17655,-17437,-14599,-443,31394,-11128,16691,17973,11127,-10860,4216},
  {7400,25293,18628,1844,11031,-20291,11130,10468,-19292,15417,-6600,20955,-24952,17560,9256,-15720,6337,-7361,25410,18985,-19893,20782,23898,28835,-18683,11808,-32253,-28307,-10022,15295,27817,10425,-8323,-10936,-16158,32011,-9465,-19720,13841,-20791,7198,20616,103,2316,12139,6532,13510,-9757,-18802,6093,-8847,-14013,7353,-28600,27771,-21826,28201,-28653,15897,-31123,-8524,-2180,-7369,12609,5703,29035,11096,-17447,30805,-12461,-8024,12743,-26486,7924,-16418,20131,10865,19121,-30302,4226,22409,774,-10905,-17962,-20779,10712,-31584,-3569,20665,-20458,-17485,-27210,-6179,-22194,28172,19410,29739,-27539,6640,12605,-21028,897,-19206,-810,-26307,-25115,-27190,-6961,19547,-24086,-11628,-29263,13031,4975,24237,-31642,-21364,-6053,-14517,26417,-31695,-22012,18686,25397,-17124,-23012,-2226,24311,-8706,20523,18981,-21190,-19057,23587,18753,-9309,-7836,-19118,-32630,-4050,-24605,10328,-2945,8676,19350,-2774,572,15937,27180,-17313,-7372,-28435,17507,3065,-12627,-28509,20582,-20872,25713,-9944,-12986,-22225,6002,-14909,17795,-9637,15567,20296,27806,-24220,6000,-24935,31355,16297,3747,-21440,25320,6432,17968,28050,-4808,6159,-23234,30193,-11111,2696,30929,-1249,9884,-22701,28559,-30992,29693,29693,28849,22928,14875,-2355,-27645,-28273,-10656,-12895,31913,-13757,17814,4307,31163,-19038,-8532,12274,-28717,30835,-19208,-1968,-5770,9751,31000,-20007,-7325,-14419,-16353,3500,13950,28083,-11313,9974,-24798,-26506,28528,-8759,15974,12362,-4098,-8500,5116,5663,22013,24260,13718,13931,30282,-11862,7501,-16194,-30282,-23998,3936,-28475,18710,-20644,28242,-11673,-5686,-25578,24023,10669,950,22608,5001,21954,8481,15763,-24160,-24903,25567,19889,-10977,14565,14389,-4582,7533,4076,-18737,5019,31399,16832,20876,-16609,-30653,-31869,1710,18042,18485,19857,-32348,7713,-20522,30396,-6627,-26174,26518,21982,6800,8690,32632,13984,2363,-27825,-20907,-30610,-19662,9045,-173,26044,4632,17445,-16053,-2489,16675,30814,-19372,9338,-16526,-31290,-1680,10392,28473,12583,-6599,-27185,-10990,-22689,25716,26897,-14290,-13352,31233,23878,-29194,3939,16914,-22126,-7324,2882,27725,-19241,-4360,7820,31457,12929,-31705,-11309,-19052,-15055,540,17197,-765,-6059,-25423,-14050,-16955,-13491,-31732,-7234,22883,9604,-17323,25855,11680,27002,16851,119,-31022,-16695,-1884,-23993,15220,5911,24521,24288,-9033,-24991,25107,-31839,-17177,-10440,14943,3939,17905,192,-6703,-31211,29990,-11603,27189,15266,5393,26265,11849,32071,29862,662,25561,-5771,-24475,11100,-8812,-9613,3873,10047,8579,-26457,1952,4340,-14502,-10663,7580,-30858,28027,-10330,-786,18223,-17788,-21900,1669,-24419,-28057,9609,25511,5684,-5045,-31256,21523,-12365,28779,-17159,21797,3350,12144,15804,-30837,-27483,-2515,12680,-1561,-27293,23267,4053,720,-25560,-20002,-135,16052,-17003,-2384,-26130,3878,27625,19479,20442,31001,-13424,-2601,-26583,30269,19912,9606,16329,-17736,-338,4614,6216,24328,-18205,-13945,-9855,3245,26909,-23267,-16550,11340,22680,-8883,-9565,25380,109,-22103,26777,-4010,10082,5887,-9300,-8671,-29053,-7235,31992,14594,-3788,-18310,9100,-3916,-23890,-4616,18518,-8320,26833,-32484,-8573,31764,-381,15712,-12039,-18985,-21664,1239,-29394,6815,-13391,-12848,-12274,-23565,-23691,-29232,2962,-9668,21781,20708,23109,-23265,-24223,4132,31808,-23275,-1994,-24043,-23766,22762,16789,-15802,2674,-17187,-9208,25113,-13579,7960,24380,14943,12153,-23608,-32110,-32392,1307,-2826,2076,-28821,27558,-14145,18577,4861,-13400,-16208,29717,-24,-30397,20474,-6962,-20064,-20214,-15586,-29704,3611,-5034,-14800,16134,-28356,-23456,-24962,-17516,26607,-18239,-6268,-5241,12944,-15470,6261,-1232,-11175,4799,18452,-31296,13613,-23473,-12971,-30506,14844,-19420,12368,4579,5361,25308,-426,-16714,28903,-21536,16643,6437,-1453,-14089,-31992,4500,30194,-21035,-1863,1085,-24906,-9774,-26271,7763,8244,21155,22038,-30988,-23949,-22190,556,-15015,-16460,16022,3920,2135,27526,5737,28806,-3941,-684,-28389,-20676,-31434,-15108,-22814,15628,-16435,25948,-11401,10668,-22989,21257,17033,13367,-13553,8378,-31933,13846,-22290,26164,2131,1727,23605,-7185,14127,-12667,22667,17996,-1593,-7952,10296,29711,-21624,-1165,32014,31498,-5430,-22652,-22199,31846,-13542,29234,21313,10837,25866,-26621,-13741,-13871,-29490,90,16603,-7476,-1225,25531,30434,-1937,-7282,-111,-21727,-29114,-14152,-21757,21628,23995,-28462,27192,-9245,24528,7025,5024,22602,6826,13832,-24801,-4867,-2498,-16724,15027,30394,-31946,7089,2217,25543,-22416,-25370,-20953,24877,10569,16321,10078,-24708,-9420,-22716,4245,25729,20241,-25499,-29093,-2424,11107,-25540,17893,-1936,31681,18434,-4072,-29142,-24885,19703,14621,32708,19385,-23489,26924,4956,20061,26721,1667,26406,-21150,4184,30252,22199,32674,26078,1688,-18975,28686,32558,-15543,-19626,-185,-13056,11749,-8059,-16306,18129,-25051,-14149,-25119,-12013,3870,-15421,-8211,-13385,-30890,24124,-28518,4761,-6651,-10350,-26289,-15194,5639,-21066,9177,23594,16661,-29589,-10884,-12377,859,-13672,-11211,5832,-340,3503,-11730,-19140,-7133,-31704,-27855,-7753,260,22020,-5615,-25384,168,-13367,4394,-13760,20198,11383,-11452,22103,7697,7154,-5956,-32528,-4136,-29199,10451,-15565,2223,5751,-22270,-25084,7998,-19536,-5267,-18960,-12166,21961,6403,10504,3472,-10469,-23316,10652,13099,-11268,-7322,-17371,-30012,-26450,-4902,7371,-22113,-32493,6109,30674,-11719,3528,32403,-12132,22135,2938,-28535,-30882,-2966,-32692,18600,-24008,30500,-9641,5521,-28182,-11695,-22238,9420,12084,-32581,-8090,-29872,-30829,-16696,-25969,-7987,-10269,-9326,18062,22980,-5336,-22407,29351,-25131,7799,-30384,-16958,2872,8725,-25667,26183,-4292,27805,27639,-28901,-19734,-8997,1435,30651,4374,7987,15508,25549,23497,19749,-15785,-843,27928,16492,-12755,-10067,-16437,26955,6407,14671,7491,-20189,8093,4506,20727,-18896,29263,3976,26018,9852,17252,-17538,32622,-19391,-11655,-32610,6404,20318,-7638,-11135,23955,427,28056,-32071,2120,-13933,7819,-5661,14061,-22314,26949,31453,-20359,23910,-8139,-24844,15108,7682,3619,27452,23476,-28092,-5848,28760,27817,-23574,27815,32616,17391,14543,1103,8313,-22502,-12249,20511,11452,-13774,7954,-16736,-3748,-1244,32073,-6775,-24474,-17942,-29562,-22782,16024,-25497,-26748,23370,-25624,-15313,21915,-27202,-30806,7577,-14873,-23273,-9473,4048,17791,-21952,-27328,2487,13731,-32570,-29502,14456,25723,30263,-15530,2900,-9427,25336,-17746,-10688,9546,-13449,-23322,-10205,-18011,-12812,23406,-11649,-7165,13619,-13099,-3280,-4594,-19266,31770,30877,10691,-17039,31185,-31375,-26226,27392,-23637,4562,30256,24808,7735,-21992,22036,30584,-14491,-22395,-32486,-11582,22191,-30317,-25888,-17335,-30168,27385,-8723,-31902,-22732,-18729,-24555,14376,-4258,9245,20774,15127,-29300,-12909,-31788,-30747,5634,-10742,20588,-24456,-27150,-27729,24146,30703,-3848,-17914,-646,25738,-23366,2161,29443,32520,-5976,-16955,28387,-12851,-7506,-18042,31355,-31998,-26004,17657,-16039,-8985,-12853,-32131,7086,-28191,-965,-3899,-12939,19270,23588,-26974,-32092,-20803,23890,18129,-30058,32202,-9953,31649,11282,-13080,-19189,24816,15716,28793,21487,-9018,-7172,32611,29639,22073,-2904,13138,28622,5190,7435,16639,7999,15077,18784,-21121,-7309,-32154,18400,15835,-23113,895,19294,26899,17444,25013,-7306,13671,14235,2623,-3669,13402,-22641,27015,10772,11340,15552,32693,17085,24131,-27043,2830,-1858,30318,8982,11227,-12708,-8613,19334,-29871,14684,11635,-589,19261,-17530,32168,-4821,29922,7148,11317,10242,13715,15773,-16084,-4923,27168,-7886,29971,23267,-32366,-19075,2194,14255,18374,-32416,22264,5875,-1553,-30460,-25884,-2893,-17751,13781,-4999,27251,23873,-4844,31245,23405,-8517,1557,7551,-14006,-27583,-17195,5963,-1357,2512,15761,27092,-657,30308,5634,18971,-16151,-6106,-3091,-9437,12892,23627,22651,15441,13841,-3859,19114,16729,21018,12193,-12583,-17324,-5696,23794,10299,-29553,-16923,-24191,12500,10867,14584,-13597,17334,13207,-24825,5867,27007,4411,22124,24768,15834,-25344,-26019,-30618,-27845,29512,19930,-31028,30133,10212,4540,-19895,3927,11038,-20677,-19416,16662,-5120,-10210,-32603,14006,4470,8378,1481},
} ;

static void test_encode_1277xfreeze3_impl(long long impl)
{
  unsigned char *s = test_encode_1277xfreeze3_s;
  unsigned char *x = test_encode_1277xfreeze3_x;
  unsigned char *s2 = test_encode_1277xfreeze3_s2;
  unsigned char *x2 = test_encode_1277xfreeze3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1277xfreeze3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1277xfreeze3(impl);
    printf("encode_1277xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277xfreeze3_implementation(impl),ntruprime_dispatch_encode_1277xfreeze3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1277xfreeze3;
    printf("encode_1277xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_1277xfreeze3_implementation(),ntruprime_encode_1277xfreeze3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1277xfreeze3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1277xfreeze3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1277xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1277xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1277xfreeze3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1277xfreeze3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1277xfreeze3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277xfreeze3")) return;
  storage_encode_1277xfreeze3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1277xfreeze3_s = aligned(storage_encode_1277xfreeze3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1277xfreeze3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1277xfreeze3_x = aligned(storage_encode_1277xfreeze3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1277xfreeze3_s2 = callocplus(maxalloc);
  test_encode_1277xfreeze3_s2 = aligned(storage_encode_1277xfreeze3_s2,crypto_encode_STRBYTES);
  storage_encode_1277xfreeze3_x2 = callocplus(maxalloc);
  test_encode_1277xfreeze3_x2 = aligned(storage_encode_1277xfreeze3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1277xfreeze3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1277xfreeze3();++impl)
      forked(test_encode_1277xfreeze3_impl,impl);
    ++test_encode_1277xfreeze3_s;
    ++test_encode_1277xfreeze3_x;
    ++test_encode_1277xfreeze3_s2;
    ++test_encode_1277xfreeze3_x2;
  }
  free(storage_encode_1277xfreeze3_x2);
  free(storage_encode_1277xfreeze3_s2);
  free(storage_encode_1277xfreeze3_x);
  free(storage_encode_1277xfreeze3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

