#
# Sonatype Nexus (TM) Open Source Version
# Copyright (c) 2008-present Sonatype, Inc.
# All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
#
# This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
# which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
#
# Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
# of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
# Eclipse Foundation. All other trademarks are the property of their respective owners.
#

require 'minitest/autorun'
require 'nexus/dependency_data_impl'

describe Nexus::DependencyDataImpl do

  Nexus::VERSIONS = [{:number=>"1.0.0", :platform=>"x86-mswin32-60"}, {:number=>"1.0.0", :platform=>"ruby"}, {:number=>"1.0.1", :platform=>"ruby"}, {:number=>"1.0.2", :platform=>"ruby"}, {:number=>"1.0.3", :platform=>"ruby"}, {:number=>"1.0.3", :platform=>"x86-mswin32-60"}, {:number=>"1.0.4", :platform=>"x86-mswin32-60"}, {:number=>"1.0.4", :platform=>"ruby"}, {:number=>"1.0.5", :platform=>"x86-mswin32-60"}, {:number=>"1.0.5", :platform=>"ruby"}, {:number=>"1.0.6", :platform=>"x86-mswin32-60"}, {:number=>"1.0.6", :platform=>"ruby"}, {:number=>"1.0.7", :platform=>"ruby"}, {:number=>"1.0.7", :platform=>"x86-mswin32-60"}, {:number=>"1.1.0", :platform=>"ruby"}, {:number=>"1.1.0", :platform=>"x86-mswin32-60"}, {:number=>"1.1.1", :platform=>"x86-mswin32-60"}, {:number=>"1.1.1", :platform=>"java"}, {:number=>"1.1.1", :platform=>"ruby"}, {:number=>"1.2.0", :platform=>"x86-mswin32-60"}, {:number=>"1.2.0", :platform=>"java"}, {:number=>"1.2.0", :platform=>"ruby"}, {:number=>"1.2.1", :platform=>"java"}, {:number=>"1.2.1", :platform=>"ruby"}, {:number=>"1.2.1", :platform=>"x86-mswin32-60"}, {:number=>"1.2.2", :platform=>"java"}, {:number=>"1.2.2", :platform=>"x86-mswin32-60"}, {:number=>"1.2.2", :platform=>"ruby"}, {:number=>"1.2.3", :platform=>"ruby"}, {:number=>"1.2.3", :platform=>"java"}, {:number=>"1.2.3", :platform=>"x86-mswin32-60"}, {:number=>"1.3.0", :platform=>"java"}, {:number=>"1.3.0", :platform=>"x86-mswin32"}, {:number=>"1.3.0", :platform=>"ruby"}, {:number=>"1.3.0", :platform=>"x86-mingw32"}, {:number=>"1.3.1", :platform=>"ruby"}, {:number=>"1.3.1", :platform=>"x86-mingw32"}, {:number=>"1.3.1", :platform=>"java"}, {:number=>"1.3.1", :platform=>"x86-mswin32"}, {:number=>"1.3.2", :platform=>"x86-mingw32"}, {:number=>"1.3.2", :platform=>"java"}, {:number=>"1.3.2", :platform=>"x86-mswin32"}, {:number=>"1.3.2", :platform=>"ruby"}, {:number=>"1.3.3", :platform=>"x86-mingw32"}, {:number=>"1.3.3", :platform=>"java"}, {:number=>"1.3.3", :platform=>"ruby"}, {:number=>"1.3.3", :platform=>"x86-mswin32"}, {:number=>"1.4.0", :platform=>"ruby"}, {:number=>"1.4.0", :platform=>"java"}, {:number=>"1.4.0", :platform=>"x86-mswin32"}, {:number=>"1.4.0", :platform=>"x86-mingw32"}, {:number=>"1.4.1", :platform=>"x86-mingw32"}, {:number=>"1.4.1", :platform=>"ruby"}, {:number=>"1.4.1", :platform=>"java"}, {:number=>"1.4.1", :platform=>"x86-mswin32"}, {:number=>"1.4.2", :platform=>"ruby"}, {:number=>"1.4.2", :platform=>"java"}, {:number=>"1.4.2.1", :platform=>"x86-mswin32"}, {:number=>"1.4.2.1", :platform=>"x86-mingw32"}, {:number=>"1.4.3", :platform=>"x86-mingw32"}, {:number=>"1.4.3", :platform=>"ruby"}, {:number=>"1.4.3", :platform=>"x86-mswin32"}, {:number=>"1.4.3", :platform=>"java"}, {:number=>"1.4.3.1", :platform=>"java"}, {:number=>"1.4.3.1", :platform=>"x86-mswin32"}, {:number=>"1.4.3.1", :platform=>"ruby"}, {:number=>"1.4.3.1", :platform=>"x86-mingw32"}, {:number=>"1.4.4", :platform=>"x86-mswin32"}, {:number=>"1.4.4", :platform=>"ruby"}, {:number=>"1.4.4", :platform=>"x86-mingw32"}, {:number=>"1.4.4", :platform=>"java"}, {:number=>"1.4.4.1", :platform=>"x86-mswin32"}, {:number=>"1.4.4.1", :platform=>"x86-mingw32"}, {:number=>"1.4.4.2", :platform=>"java"}, {:number=>"1.4.5", :platform=>"x86-mingw32"}, {:number=>"1.4.5", :platform=>"ruby"}, {:number=>"1.4.5", :platform=>"x86-mswin32-60"}, {:number=>"1.4.5", :platform=>"java"}, {:number=>"1.4.6", :platform=>"ruby"}, {:number=>"1.4.6", :platform=>"x86-mswin32-60"}, {:number=>"1.4.6", :platform=>"x86-mingw32"}, {:number=>"1.4.6", :platform=>"java"}, {:number=>"1.4.7", :platform=>"ruby"}, {:number=>"1.4.7", :platform=>"x86-mingw32"}, {:number=>"1.4.7", :platform=>"x86-mswin32-60"}, {:number=>"1.4.7", :platform=>"java"}, {:number=>"1.5.0", :platform=>"x86-mswin32-60"}, {:number=>"1.5.0", :platform=>"ruby"}, {:number=>"1.5.0", :platform=>"x86-mingw32"}, {:number=>"1.5.0", :platform=>"java"}, {:number=>"1.5.0.beta.1", :platform=>"java"}, {:number=>"1.5.0.beta.1", :platform=>"ruby"}, {:number=>"1.5.0.beta.2", :platform=>"java"}, {:number=>"1.5.0.beta.2", :platform=>"ruby"}, {:number=>"1.5.0.beta.3", :platform=>"java"}, {:number=>"1.5.0.beta.3", :platform=>"ruby"}, {:number=>"1.5.0.beta.4", :platform=>"java"}, {:number=>"1.5.0.beta.4", :platform=>"ruby"}, {:number=>"1.5.1", :platform=>"x86-mswin32-60"}, {:number=>"1.5.1", :platform=>"java"}, {:number=>"1.5.1", :platform=>"ruby"}, {:number=>"1.5.1", :platform=>"x86-mingw32"}, {:number=>"1.5.1.rc1", :platform=>"x86-mingw32"}, {:number=>"1.5.1.rc1", :platform=>"x86-mswin32-60"}, {:number=>"1.5.1.rc1", :platform=>"java"}, {:number=>"1.5.1.rc1", :platform=>"ruby"}, {:number=>"1.5.10", :platform=>"x86-mingw32"}, {:number=>"1.5.10", :platform=>"x86-mswin32-60"}, {:number=>"1.5.10", :platform=>"java"}, {:number=>"1.5.10", :platform=>"ruby"}, {:number=>"1.5.11", :platform=>"x86-mswin32-60"}, {:number=>"1.5.11", :platform=>"java"}, {:number=>"1.5.11", :platform=>"x86-mingw32"}, {:number=>"1.5.11", :platform=>"ruby"}, {:number=>"1.5.2", :platform=>"ruby"}, {:number=>"1.5.2", :platform=>"java"}, {:number=>"1.5.2", :platform=>"x86-mswin32-60"}, {:number=>"1.5.2", :platform=>"x86-mingw32"}, {:number=>"1.5.3", :platform=>"ruby"}, {:number=>"1.5.3", :platform=>"java"}, {:number=>"1.5.3", :platform=>"x86-mingw32"}, {:number=>"1.5.3", :platform=>"x86-mswin32-60"}, {:number=>"1.5.3.rc2", :platform=>"java"}, {:number=>"1.5.3.rc2", :platform=>"ruby"}, {:number=>"1.5.3.rc2", :platform=>"x86-mswin32-60"}, {:number=>"1.5.3.rc2", :platform=>"x86-mingw32"}, {:number=>"1.5.3.rc3", :platform=>"x86-mingw32"}, {:number=>"1.5.3.rc3", :platform=>"java"}, {:number=>"1.5.3.rc3", :platform=>"ruby"}, {:number=>"1.5.3.rc3", :platform=>"x86-mswin32-60"}, {:number=>"1.5.3.rc4", :platform=>"x86-mingw32"}, {:number=>"1.5.3.rc4", :platform=>"java"}, {:number=>"1.5.3.rc4", :platform=>"ruby"}, {:number=>"1.5.3.rc4", :platform=>"x86-mswin32-60"}, {:number=>"1.5.3.rc5", :platform=>"java"}, {:number=>"1.5.3.rc5", :platform=>"x86-mingw32"}, {:number=>"1.5.3.rc5", :platform=>"ruby"}, {:number=>"1.5.3.rc5", :platform=>"x86-mswin32-60"}, {:number=>"1.5.3.rc6", :platform=>"x86-mswin32-60"}, {:number=>"1.5.3.rc6", :platform=>"x86-mingw32"}, {:number=>"1.5.3.rc6", :platform=>"ruby"}, {:number=>"1.5.3.rc6", :platform=>"java"}, {:number=>"1.5.4", :platform=>"x86-mingw32"}, {:number=>"1.5.4", :platform=>"x86-mswin32-60"}, {:number=>"1.5.4", :platform=>"java"}, {:number=>"1.5.4", :platform=>"ruby"}, {:number=>"1.5.4.rc1", :platform=>"x86-mingw32"}, {:number=>"1.5.4.rc1", :platform=>"java"}, {:number=>"1.5.4.rc1", :platform=>"x86-mswin32-60"}, {:number=>"1.5.4.rc1", :platform=>"ruby"}, {:number=>"1.5.4.rc2", :platform=>"ruby"}, {:number=>"1.5.4.rc2", :platform=>"x86-mswin32-60"}, {:number=>"1.5.4.rc2", :platform=>"java"}, {:number=>"1.5.4.rc2", :platform=>"x86-mingw32"}, {:number=>"1.5.4.rc3", :platform=>"x86-mswin32-60"}, {:number=>"1.5.4.rc3", :platform=>"ruby"}, {:number=>"1.5.4.rc3", :platform=>"x86-mingw32"}, {:number=>"1.5.4.rc3", :platform=>"java"}, {:number=>"1.5.5", :platform=>"ruby"}, {:number=>"1.5.5", :platform=>"x86-mingw32"}, {:number=>"1.5.5", :platform=>"x86-mswin32-60"}, {:number=>"1.5.5", :platform=>"java"}, {:number=>"1.5.5.rc1", :platform=>"x86-mswin32-60"}, {:number=>"1.5.5.rc1", :platform=>"java"}, {:number=>"1.5.5.rc1", :platform=>"ruby"}, {:number=>"1.5.5.rc1", :platform=>"x86-mingw32"}, {:number=>"1.5.5.rc2", :platform=>"x86-mswin32-60"}, {:number=>"1.5.5.rc2", :platform=>"ruby"}, {:number=>"1.5.5.rc2", :platform=>"java"}, {:number=>"1.5.5.rc2", :platform=>"x86-mingw32"}, {:number=>"1.5.5.rc3", :platform=>"x86-mswin32-60"}, {:number=>"1.5.5.rc3", :platform=>"ruby"}, {:number=>"1.5.5.rc3", :platform=>"x86-mingw32"}, {:number=>"1.5.5.rc3", :platform=>"java"}, {:number=>"1.5.6", :platform=>"x86-mingw32"}, {:number=>"1.5.6", :platform=>"java"}, {:number=>"1.5.6", :platform=>"ruby"}, {:number=>"1.5.6", :platform=>"x86-mswin32-60"}, {:number=>"1.5.6.rc1", :platform=>"java"}, {:number=>"1.5.6.rc1", :platform=>"ruby"}, {:number=>"1.5.6.rc2", :platform=>"java"}, {:number=>"1.5.6.rc2", :platform=>"x86-mswin32-60"}, {:number=>"1.5.6.rc2", :platform=>"x86-mingw32"}, {:number=>"1.5.6.rc2", :platform=>"ruby"}, {:number=>"1.5.6.rc3", :platform=>"ruby"}, {:number=>"1.5.6.rc3", :platform=>"x86-mswin32-60"}, {:number=>"1.5.6.rc3", :platform=>"java"}, {:number=>"1.5.6.rc3", :platform=>"x86-mingw32"}, {:number=>"1.5.7", :platform=>"java"}, {:number=>"1.5.7", :platform=>"ruby"}, {:number=>"1.5.7", :platform=>"x86-mingw32"}, {:number=>"1.5.7", :platform=>"x86-mswin32-60"}, {:number=>"1.5.7.rc1", :platform=>"ruby"}, {:number=>"1.5.7.rc1", :platform=>"x86-mswin32-60"}, {:number=>"1.5.7.rc1", :platform=>"x86-mingw32"}, {:number=>"1.5.7.rc1", :platform=>"java"}, {:number=>"1.5.7.rc2", :platform=>"x86-mswin32-60"}, {:number=>"1.5.7.rc2", :platform=>"x86-mingw32"}, {:number=>"1.5.7.rc2", :platform=>"ruby"}, {:number=>"1.5.7.rc2", :platform=>"java"}, {:number=>"1.5.7.rc3", :platform=>"java"}, {:number=>"1.5.7.rc3", :platform=>"x86-mswin32-60"}, {:number=>"1.5.7.rc3", :platform=>"x86-mingw32"}, {:number=>"1.5.7.rc3", :platform=>"ruby"}, {:number=>"1.5.8", :platform=>"x86-mswin32-60"}, {:number=>"1.5.8", :platform=>"java"}, {:number=>"1.5.8", :platform=>"x86-mingw32"}, {:number=>"1.5.8", :platform=>"ruby"}, {:number=>"1.5.9", :platform=>"java"}, {:number=>"1.5.9", :platform=>"x86-mingw32"}, {:number=>"1.5.9", :platform=>"x86-mswin32-60"}, {:number=>"1.5.9", :platform=>"ruby"}, {:number=>"1.6.0", :platform=>"ruby"}, {:number=>"1.6.0", :platform=>"java"}, {:number=>"1.6.0", :platform=>"x86-mingw32"}, {:number=>"1.6.0", :platform=>"x86-mswin32-60"}, {:number=>"1.6.0.rc1", :platform=>"ruby"}, {:number=>"1.6.1", :platform=>"x86-mswin32-60"}, {:number=>"1.6.1", :platform=>"x86-mingw32"}, {:number=>"1.6.1", :platform=>"ruby"}, {:number=>"1.6.1", :platform=>"java"}, {:number=>"1.6.2.rc1", :platform=>"x86-mingw32"}, {:number=>"1.6.2.rc1", :platform=>"ruby"}, {:number=>"1.6.2.rc1", :platform=>"x64-mingw32"}, {:number=>"1.6.2.rc1", :platform=>"java"}, {:number=>"1.6.2.rc2", :platform=>"ruby"}, {:number=>"1.6.2.rc2", :platform=>"java"}, {:number=>"1.6.2.rc2", :platform=>"x64-mingw32"}, {:number=>"1.6.2.rc2", :platform=>"x86-mingw32"}, {:number=>"9.9.7", :platform=>"universal-java"}, {:number=>"9.9.7", :platform=>"univeral-ruby"}, {:number=>"9.9.8", :platform=>"universal-jruby"}, {:number=>"9.9.9", :platform=>"jruby"}]

  subject do
    Nexus::DependencyDataImpl.new( Nexus::VERSIONS, 'nokogiri', 123 )
  end

  it 'has a name and modified' do
    subject.name.must_equal 'nokogiri'
    subject.modified.must_equal 123
  end

  it 'retrieves the java platform' do
    subject.platform( '1.5.11' ).must_equal 'java'
    subject.platform( '9.9.9' ).must_equal 'jruby'
    subject.platform( '9.9.8' ).must_equal 'universal-jruby'
    subject.platform( '9.9.7' ).must_equal 'universal-java'
    subject.platform( '1.0.0' ).must_equal 'ruby'
  end

  it 'separates preleases and releases versions' do
    pre = subject.versions( true )
    re = subject.versions( false )
    ( pre - re ).must_equal pre
    ( re - pre ).must_equal re
    pre.empty?.wont_be_nil
    re.empty?.wont_be_nil
    pre.each { |d| d.must_match /[a-zA-Z]/ }
    re.each { |d| d.must_match /^[0-9.]+$/ }
  end

  it 'has no releases' do
    deps = Nexus::DependencyDataImpl.new( [{:name=>"pre", :number=>"0.1.0.beta", :platform=>"ruby", :dependencies=>[]}], 'pre', 321 )
    deps.modified.must_equal 321
    deps.name.must_equal 'pre'
    deps.versions( false ).must_equal []
    deps.versions( true ).must_equal ["0.1.0.beta"]
  end
end

